% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\encoding{UTF-8}
\name{format_num}
\alias{format_num}
\title{Format numbers for presentation}
\usage{
format_num(x, digits = 2L, decimal.mark = getOption("OutDec"),
  leading0 = "conditional", drop0integer = FALSE,
  neg.sign = "&minus;", pos.sign = "figure", big.mark = "&#8239;",
  big.interval = 3L, small.mark = "&#8239;", small.interval = 3L,
  na.mark = "&mdash;", lgl.mark = c("+", "&minus;"),
  inf.mark = c("+&infin;", "&minus;&infin;"))
}
\arguments{
\item{x}{A vector, matrix, or data.frame of numbers to format}

\item{digits}{The number of decimal digits desired (used strictly; default: 2)}

\item{decimal.mark}{The character to use for the decimal point (defaults to locale default: \code{getOption("OutDec")})}

\item{leading0}{How to print leading zeros on decimals. Can be logical to print (\code{TRUE}) or suppress (\code{FALSE}) leading zeros or a character string to subsitute for leading zeros. If \code{"conditional"} (default), leading zeros are shown if a column contains any absolute values greater than 1 and suppressed otherwise. If \code{"figure"}, leading zeros are replaced with a figure space (\href{https://unicode-table.com/en/2007/}{\code{U+2007}}) if a column contains any absolute values greater than 1 and suppressed otherwise.}

\item{drop0integer}{Logical. Should trailing decimal zeros be dropped for integers?}

\item{neg.sign}{Character to use as negative sign. Defaults to minus-sign (\href{https://unicode-table.com/en/2212/}{\code{U+2212}}).}

\item{pos.sign}{Character to use as positive sign. Set to \code{FALSE} to suppress. If \code{"figure"} (default), the positive sign is a figure-space (\href{https://unicode-table.com/en/2007/}{\code{U+2007}}) if a column contains any negative numbers and suppressed otherwise.}

\item{big.mark}{Character to mark between each \code{big.interval} digits \emph{before} the decimal point. Set to \code{FALSE} to suppress. Defaults to the SI/ISO 31-0 standard-recommened thin-spaces (\href{https://unicode-table.com/en/202f/}{\code{U+202F}}).}

\item{big.interval}{See \code{big.mark} above; defaults to 3.}

\item{small.mark}{Character to mark between each \code{small.interval} digits \emph{after} the decimal point. Set to \code{FALSE} to suppress. Defaults to the SI/ISO 31-0 standard-recommened thin-spaces (\href{https://unicode-table.com/en/202f/}{\code{U+202F}}).}

\item{small.interval}{See \code{small.mark} above; defaults to 3.}

\item{na.mark}{Character to replace \code{NA} and \code{NaN} values. Defaults to em-dash (\href{https://unicode-table.com/en/2014/}{\code{U+2014}}))}

\item{lgl.mark}{A length 2 vector containing characters to replace \code{TRUE} and \code{FALSE}. Defaults to c("+", "\href{https://unicode-table.com/en/2212/}{\code{U+2212}}").}

\item{inf.mark}{A length 2 vector containing characters to replace \code{Inf} and \code{-Inf}. Defaults to c("+\href{https://unicode-table.com/en/221e/}{\code{U+221e}}", "\href{https://unicode-table.com/en/2212/}{\code{U+2212}}\href{https://unicode-table.com/en/221e/}{\code{U+221e}}").}
}
\description{
A function to format numbers and logical values as characters for display purposes.
Includes control over formatting of decimal digits, leading zeros, sign characters,
and characters to replace logical, NA, NaN, and Inf values. Factors are converted
to strings. Strings are returned verbatim.
}
\examples{
# format_num() converts numeric values to characters with the specified formatting options.
# By default, thousands digit groups are separated by thin spaces, negative signs are replaced
# with minus signs, and positive signs and leading zeros are replaced with figure spaces
# (which have the same width as numbers and minus signs). These options ensure that all
# results will align neatly in columns when tabled.
format_num(x = c(10000, 1000, 2.41, -1.20, 0.41, -0.20))

# By default, format_num() uses your computer locale's default decimal mark as
# the decimal point. To force the usage of "." instead (e.g., for submission to
# a U.S. journal), set decimal.mark = ".":
format_num(x = .41, decimal.mark = ".")

# By default, format_num() separates groups of large digits using thin spaces.
# This is following the international standard for scientific communication (SI/ISO 31-0),
# which advises against using "." or "," to seprate digits because doing so can lead
# to confusion for human and computer readers because "." and "," are also used
# as decimal marks in various countries. If you prefer to use commmas to separate
# large digit groups, set big.mark = ",":
format_num(x = 10000, big.mark = ",")
}
