% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_r.R
\name{correct_r_meas}
\alias{correct_r_meas}
\title{Correct correlations for measurement error}
\usage{
correct_r_meas(rxy, rxx = 1, ryy = 1, n = NULL, conf_level = 0.95,
  correct_bias = FALSE)
}
\arguments{
\item{rxy}{Vector of observed correlations.}

\item{rxx}{Vector of reliability coefficients for X.}

\item{ryy}{Vector of reliability coefficients for Y.}

\item{n}{Optional vector of sample sizes associated with the rxy correlations.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{correct_bias}{Logical argument that determines whether to correct error-variance estimates for small-sample bias in correlations (\code{TRUE}) or not (\code{FALSE}).
For sporadic corrections (e.g., in mixed artifact-distribution meta-analyses), this should be set to \code{FALSE}, the default).}
}
\value{
Data frame(s) of observed correlations (\code{rxy}), operational correlations corrected for measurement error in Y only (\code{rxp}), operational correlations corrected for measurement error in X only (\code{rty}), and true-score correlations (\code{rtp}).
}
\description{
Correct correlations for measurement error
}
\details{
\deqn{\rho_{TP}=\frac{\rho_{XY}}{\sqrt{\rho_{XX}\rho_{YY}}}}{rtp = rxy / sqrt(rxx * ryy)}
}
\examples{
correct_r_meas(rxy = .3, rxx = .8, ryy = .8)
correct_r_meas(rxy = .3, rxx = .8, ryy = .8, n = 100)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: SAGE. \url{https://doi.org/10/b6mg}. pp. 140–141.
}
\keyword{internal}
