## -----------------------------------------------------------------------------
library(psr)

## -----------------------------------------------------------------------------
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c('Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 3')
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)

## -----------------------------------------------------------------------------
TE(subject, trial, metric_1, metric_2, metric_3)

## -----------------------------------------------------------------------------
CV(subject, trial, metric_1, metric_2, metric_3)

## -----------------------------------------------------------------------------
SEM(subject, trial, metric_1, metric_2, metric_3, ICC = c(0.99, 0.93, 0.99))

## ---- warning=FALSE, message=FALSE--------------------------------------------
ICC_long(subject, trial, metric_1, metric_2, metric_3)

## -----------------------------------------------------------------------------
SWC(subject, trial, metric_1, metric_2, metric_3, effect_size = 0.2, method = 'AVG')

## -----------------------------------------------------------------------------
MDC(subject, trial, metric_1, metric_2, metric_3, ICC = c(0.99, 0.93, 0.99), confidence = 0.95)

## -----------------------------------------------------------------------------
MDC(subject, trial, metric_1, metric_2, metric_3, ICC = c(0.99, 0.93, 0.99), confidence = 0.80)

## -----------------------------------------------------------------------------
STEN(subject, trial, metric_1, metric_2, metric_3)

## -----------------------------------------------------------------------------
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c('Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 4')
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
TE(subject, trial, metric_1, metric_2, metric_3)

## -----------------------------------------------------------------------------
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c('Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 2')
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
TE(subject, trial, metric_1, metric_2, metric_3)

## -----------------------------------------------------------------------------
# subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
# trial <- c('Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 3', 'Trial 1', 'Trial 2', 'Trial 3')
# metric_1 <- c("abc", "def", "ghi", "jkl", "mno", "pqr", "stu", "vwx", "yzz")
# metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
# metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
# TE(subject, trial, metric_1, metric_2, metric_3)

