% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareMatrix.R
\name{prepareMatrix}
\alias{prepareMatrix}
\title{given table of peptide protein assigments generate matrix}
\usage{
prepareMatrix(data, proteinID = "proteinID", peptideID = "strippedSequence",
  weighting = NULL, sep = "|")
}
\arguments{
\item{data}{generated by annotatePeptides}

\item{proteinID}{protein ID column}

\item{peptideID}{peptide / precursor ID column}

\item{weighting}{weight type to use. Options are "one" , "AA" - amino acids, "coverage" - coverage , "inverse" - inverse peptide frequencies}

\item{sep}{separator for precursor (rownames)}
}
\value{
sparse matrix
}
\description{
given table of peptide protein assigments generate matrix
}
\examples{
library(prozor)
data(protpepmetashort)
library(Matrix)
colnames(protpepmetashort)
head(protpepmetashort)
dim(protpepmetashort)
count = prepareMatrix( protpepmetashort, peptideID = "peptideSeq" )
dim(count)
inverse = prepareMatrix( protpepmetashort, peptideID = "peptideSeq" , weight = "inverse")
#aa = prepareMatrix(protpepmetashort,  peptideID = "peptideSeq" , weight = "AA")
#xx = prepareMatrix(protpepmetashort,  peptideID = "peptideSeq" , weight = "coverage")
image( as.matrix(count) )

corProt = cor( as.matrix(count) )
par(mfrow =c(1,2))
image(corProt)

#penalise peptides matching many proteins
corProtn = cor( as.matrix(inverse) )
image(corProtn)

}
