% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ternary}
\alias{plot.ternary}
\title{Plot a ternary diagram}
\usage{
\method{plot}{ternary}(x, type = "empty", pch = NA, pos = NULL,
  labels = names(x), showpath = FALSE, bg = NA, col = "cornflowerblue",
  ...)
}
\arguments{
\item{x}{an object of class \code{ternary}}

\item{type}{adds annotations to the ternary diagram, one of either
\code{empty}, \code{QFL.descriptive}, \code{QFL.folk} or
\code{QFL.dickinson}}

\item{pch}{plot character, see \code{?par} for details (may be a
vector)}

\item{pos}{position of the sample labels relative to the plot
symbols if pch != NA}

\item{labels}{vector of strings to be added to the plot symbols}

\item{showpath}{if \code{x} has class \code{SRDcorrected}, and
\code{showpath}==TRUE, the intermediate values of the SRD
correction will be plotted on the ternary diagram as well as
the final composition}

\item{bg}{background colour for the plot symbols (may be a vector)}

\item{col}{colour to be used for the background lines (if
applicable)}

\item{...}{optional arguments to the generic \code{points} function}
}
\description{
Plots triplets of compositional data on a ternary diagram
}
\examples{
data(Namib)
tern <- ternary(Namib$PT,'Q',c('KF','P'),c('Lm','Lv','Ls'))
plot(tern,type='QFL.descriptive',pch=21,bg='red',labels=NULL)
}
\seealso{
ternary
}
