% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc-01-AAC.R
\name{extractAAC}
\alias{extractAAC}
\title{Amino Acid Composition Descriptor}
\usage{
extractAAC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 20 named vector
}
\description{
This function calculates the Amino Acid Composition descriptor (dim: 20).
}
\examples{
x <- readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]
extractAAC(x)
}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on
Amino Acid Composition and Dipeptide Composition.
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See \code{\link{extractDC}} and \code{\link{extractTC}}
for Dipeptide Composition and Tripeptide Composition descriptors.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
