\name{memixed}
\alias{memixed}
\alias{print.memix}
\alias{plot.memix}
\alias{ResponderAnalysis}

\title{Bayesian Hierarchical Model for RPO data with repeated measures}
\usage{
memixed(x0,x1,group,method="ATT")
ResponderAnalysis(x,mcid,type="absolute",conf.level=0.95)
}
\arguments{
\item{x0,x1}{Numeric vector/matrix of observations at T0 (baseline) and
  T1 (end point) of a study.}
\item{group}{group assignments. Current version support one or two
  groups only}
\item{method}{ATT: average treatment effect on treated; ATE: average
  treatment effect. }
\item{x}{An R object generated by \code{memixed}}
\item{mcid}{A threshold to define 'responder'}
\item{type}{Type of metric used for effectiveness evaluation. Can be
  'absolute' changes, or 'relative' changes from baseline.}
\item{conf.level}{Confidence level of the credible interval} 
}
\value{
\itemize{
\item `xfit`: fitted results using stan.
\item `mu.t0`: baseline mean.
\item `sig.t0`: baseline SD.
\item `sig.me`: SD of measurement errors.
\item `mu.active`: mean effect size of active treatment.
\item `sig.active`: sd of effect size of active treatment.
\item `mu.sham`: mean effect size of sham treatment.
\item `sig.sham`: sd of effect size of sham treatment.
}
}
\description{
A Bayesian hierachical model to denoise PRO data using repeated measures.
}
\examples{
\donttest{
data(n100x3)
out1  <-  memixed(x0=ex100x3$w0,x1=ex100x3$w1,group=ex100x3$group,method="att")
out1
ResponderAnalysis(out1,mcid=1,type="abs")
out2  <-  memixed(x0=ex100x3$w0,x1=ex100x3$w1,group=ex100x3$group,method="ate")
out2
ResponderAnalysis(out2,mcid=1,type="abs")
out <- out2
ResponderAnalysis(out,mcid=0.5,type="abs")
ResponderAnalysis(out,mcid=1,type="abs")
ResponderAnalysis(out,mcid=1.5,type="abs")
ResponderAnalysis(out,mcid=0.3,type="relative")
ResponderAnalysis(out,mcid=0.2,type="relative")
ResponderAnalysis(out,mcid=0.1,type="relative")
}
}
