% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cvind}
\alias{cvind}
\title{Create cross-validation indices}
\usage{
cvind(n, k, out = "foldwise", seed = NULL)
}
\arguments{
\item{n}{Number of data points.}

\item{k}{Number of folds.}

\item{out}{Format of the output, either 'foldwise' (default) or 'indices'. See below for details.}

\item{seed}{Random seed so that the same division could be obtained again if needed.}
}
\value{
If \code{out} is 'foldwise', the returned value is a list with \code{k} elements, 
each having fields \code{tr} and \code{ts} which give the training and test indices, respectively,
for each fold. If \code{out} is 'indices', the returned value is a list with fields \code{tr} and \code{ts}
each of which is a list with \code{k} elements giving the training and test indices for each fold.
}
\description{
Divide indices from 1 to \code{n} into subsets for \code{k}-fold cross validation.
This function is potentially useful for creating the cross-validation objects for 
\link[=init_refmodel]{init_refmodel}.
}
\examples{
\donttest{
### compute sample means within each fold
n <- 100
y <- rnorm(n)
cv <- cvind(n, k=5)
cvmeans <- lapply(cv, function(fold) mean(y[fold$itr]))
}
}
