% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotted_chart.R
\name{dotted_chart}
\alias{dotted_chart}
\alias{dotted_chart.grouped_eventlog}
\alias{idotted_chart}
\alias{iplotly_dotted_chart}
\alias{plotly_dotted_chart}
\title{Dotted chart}
\usage{
dotted_chart(eventlog, x, sort, color, units, add_end_events = F, ...)

\method{dotted_chart}{grouped_eventlog}(
  eventlog,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = NULL,
  color = NULL,
  units = NULL,
  add_end_events = F,
  ...
)

idotted_chart(eventlog, plotly = FALSE)

iplotly_dotted_chart(eventlog)

plotly_dotted_chart(
  eventlog,
  x = c("absolute", "relative", "relative_week", "relative_day"),
  sort = c("start", "end", "duration", "start_week", "start_day"),
  color = NULL,
  units = c("weeks", "days", "hours", "mins", "secs"),
  ...
)
}
\arguments{
\item{eventlog}{Eventlog object}

\item{x}{Value for plot on x-axis: absolute time or relative time (since start, since start of week, since start of day)}

\item{sort}{Ordering of the cases on y-axis: start, end or duration, start_week, start_day}

\item{color}{Optional, variable to use for coloring dots. Default is the activity identifier. Use NA for no colors.}

\item{units}{Time units to use on x-axis in case of relative time.}

\item{add_end_events}{Whether to add dots for the complete lifecycle event with a different shape.}

\item{...}{Deprecated arguments}

\item{plotly}{Return plotly object}
}
\description{
Create a dotted chart to view all events in a glance
}
\section{Methods (by class)}{
\itemize{
\item \code{grouped_eventlog}: Dotted chart for grouped event log
}}

