% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contains.R
\name{contains}
\alias{contains}
\title{Check if activity is present (contained) in a case}
\usage{
contains(activity, n = 1)
}
\arguments{
\item{activity}{Activity to check. A character vector of length one. Should be an activity of the eventlog supplied with check_rule.}

\item{n}{The minimum number of times the activity should be present.}
}
\description{
This rules examines whether the supplied activity is present in a case or not. The argument `n` can be used to set a minimum number of occurences that should be present in each case. Using the function `check_rule`, this information can be added to the event log.
}
\examples{
library(bupaR)
library(eventdataR)

# Each patient should be registered at least once.
patients \%>\%
check_rule(contains("Registration"))

# Check whether some patients have received 2 or more blood tests.

patients \%>\%
check_rule(contains("Blood test", n = 2))

}
\seealso{
Other Declarative Rules: 
\code{\link{absent}()},
\code{\link{and}()},
\code{\link{contains_between}()},
\code{\link{contains_exactly}()},
\code{\link{ends}()},
\code{\link{precedence}()},
\code{\link{responded_existence}()},
\code{\link{response}()},
\code{\link{starts}()},
\code{\link{succession}()},
\code{\link{xor}()}
}
\concept{Declarative Rules}
