% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/plot.jn.R
\name{plot.jn}
\alias{plot.jn}
\title{Plot Function For Johnson-Neyman}
\usage{
\method{plot}{jn}(x, xlab = "", ylab = "", xlim = 0, ylim = 0,
  axlwd = 10, celwd = 10, cblwd = 8, \dots)
}
\arguments{
\item{x}{An object of class \code{"jn"}.}

\item{xlab}{A title for the x axis (character).}

\item{ylab}{A title for the y axis (character).}

\item{xlim}{Coordinates range for x axis (numeric vector). Determined by the range of the given data by default.}

\item{ylim}{Coordinates range for y axis (numeric vector). Determined by the range of the given data by default.}

\item{axlwd}{Axis line width (numeric vector). \code{axlwd=10} by default.}

\item{celwd}{Conditional effect line width (numeric vector). \code{celwd=10} by default.}

\item{cblwd}{Conditional band line width (numeric vector). \code{cblwd=8} by default.}

\item{\dots}{Additional arguments (not supported yet).}
}
\value{
none
}
\description{
Plot function for objects of class \code{"jn"}.
}
\examples{
\dontrun{
myModel <- lm('DV ~ IV + MOD', data=someData)
jnresults <- jn(myModel, dv='DV', iv='IV', mod='MOD')
plot(jnresults)
}
}

