% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_currency}
\alias{format_currency}
\title{Make numeric currency values human readable}
\usage{
format_currency(amount, symbol, digits)
}
\arguments{
\item{amount}{Price or vector of prices (character, numeric, or integer)}

\item{symbol}{Symbol to prepend to amount (e.g. $) see: currency_characters()}

\item{digits}{The number of decimal places. Set equal to 2 to include cents (defaults to 0 i.e. whole major currency units)}
}
\value{
A character vector
}
\description{
Make numeric currency values human readable
}
\examples{

format_currency("2423562534234", "$")
# "$2,423,562,534,234"

format_currency("2423562534234.876", "$", 0)
# "$2,423,562,534,234.88"

format_currency("2423562534234.876", "$", 2)
# "$2,423,562,534,234.88"

format_currency("2423562534234", "¥", 2)
# "¥2,423,562,534,234.00"

# format_currency() is vectorized and can accept vector arguments
format_currency(c("2423562534234", "20"), c("¥", "$"), c(1, 2))
# "¥2,423,562,534,234.0" "$20.0"

}
