% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{load_pedar}
\alias{load_pedar}
\title{Load pedar data}
\usage{
load_pedar(pressure_filepath)
}
\arguments{
\item{pressure_filepath}{String. Filepath pointing to emed pressure file}
}
\value{
A list with information about the pressure data.
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. String with sensor type
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
 }
}
\description{
Imports and formats .asc files collected on pedar system and
   exported from Novel software
}
\examples{
pedar_data <- system.file("extdata", "pedar_example.asc", package = "pressuRe")
pressure_data <- load_pedar(pedar_data)
}
