% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_add.R
\name{form_add_instruction}
\alias{form_add_instruction}
\alias{form_add_section}
\alias{form_add_item}
\title{Add an instruction, section, or item to a (pre)registration form}
\usage{
form_add_instruction(x, heading, description, overwrite = TRUE)

form_add_section(x, id, label, description, overwrite = TRUE)

form_add_item(
  x,
  id,
  label,
  description,
  section_id,
  valueTemplate = "string",
  validValues = NA,
  validation = NA,
  overwrite = TRUE
)
}
\arguments{
\item{x}{The (pre)registration form as created by \code{\link[=form_create]{form_create()}}.}

\item{heading}{The instruction's heading}

\item{description}{The description of the instruction, section, or item}

\item{overwrite}{Whether to overwrite existing content or append the
new content}

\item{id}{The identifier of the section or item}

\item{label}{The label (i.e. title) of the section or item}

\item{section_id}{The section identifier of the section the item should
be placed in}

\item{valueTemplate}{The name of the value template of the item}

\item{validValues}{The valid values (for categorical items)}

\item{validation}{The validation statement (an R expression)}
}
\value{
The modified (pre)registration form
}
\description{
Add an instruction, section, or item to a (pre)registration form
}
\examples{
### Create an empty example form
exampleForm <-
  preregr::form_create(
    title = "Example form",
    version = "0.1.0"
  ) |>
  preregr::form_show();

### Add some stuff;
exampleForm <-
  exampleForm |>
  preregr::form_add_instruction(
    heading = "First Real Instruction",
    description = "Which normally also contains real instructions here"
  ) |>
  preregr::form_add_section(
    id = "first_section",
    label = "First Real Section",
    description = "This section is very, very important."
  ) |>
  preregr::form_add_section(
    id = "second_section",
    label = "Second Real Section",
    description = "This section is even more important then the first one."
  ) |>
  preregr::form_add_item(
    id = "study_title",
    label = "Study Title",
    section_id = "first_section",
    description = paste0(
      "Think of a catching title, preferably with a colon in ",
      "the middle. Bonus points for pop culture references."
    )
  ) |>
  preregr::form_add_item(
    id = "study_authors",
    label = "Authors",
    section_id = "first_section",
    description = "Maybe list the authors, too."
  ) |>
  preregr::form_add_item(
    id = "registration_type",
    label = "Registration type",
    section_id = "second_section",
    description = paste0(
      "Describe briefly why you are (pre)registering this ",
      "study. For example, this might be a preregistration ",
      "to allow others to know you're doing this study; or to ",
      "make it clear you value transparency in science; or to ",
      "remember your original plans later on. Or this might be ",
      "a registration to update your plans after the data came ",
      "in; or to document pragmatic changes in plans."
    )
  );

### Show the result of our hard labour
preregr::form_show(exampleForm);

}
