% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_cv.R
\name{createCVgroups}
\alias{createCVgroups}
\title{Creating k-fold Cross-Validation Groups}
\usage{
createCVgroups(x = NULL, n = length(x), k = 10, useNames = TRUE)
}
\arguments{
\item{x}{vector of observation ID's (character or numeric) to split into cv groups.}

\item{n}{number of observations to split into cv groups. Defaults to the length of \code{x}, but can also be provided instead of \code{x}.}

\item{k}{number of cross-validation groups. Must be less than or equal to \code{n}.}

\item{useNames}{logical indicator of whether the names of 'x' should be used to identify observations within cv groups.}
}
\value{
A list of length \code{k} giving the IDs of observations within each test group.
}
\description{
Splits a vector of observation names or indices into a list of k groups, to be used as cross-validation (CV) test groups.
}
\examples{
# 5-fold groups
cv5 <- createCVgroups(n=100, k=5)
cv5

# Leave-one-out
cvLOO <- createCVgroups(n=100, k=0)
cvLOO
}
\seealso{
predkmeansCVest predkmeansCVpred
}
\author{
Joshua Keller
}
