% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_comparison.R
\name{scaling_comparison}
\alias{scaling_comparison}
\title{Scaling Comparison.}
\usage{
scaling_comparison(dfm_object_list, dimensions = 2,
  distance_method = "cosine", verbose = TRUE)
}
\arguments{
\item{dfm_object_list}{A list of quanteda dfm objects returned in the
`$dfm_list$ field of the output from the `factorial_preprocessing()` function.}

\item{dimensions}{The number of dimensions to be used by the multidimensional
scaling algorithm. Defaults to 2.}

\item{distance_method}{The method that should be used for calculating
document distances. Defaults to "cosine".}

\item{verbose}{Logical indicating whether more information should be printed
to the screen to let the user know about progress. Defaults
to TRUE.}
}
\value{
A result list object.
}
\description{
Scale each dfm and return a list of distance matrices and
scaled document positions.
}
\examples{
\dontrun{
# *** This function is used automatically inside of the preText() function.
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
# scale documents
scaling_results <- scaling_comparison(preprocessed_documents$dfm_list,
                                      dimensions = 2,
                                      distance_method = "cosine",
                                      verbose = TRUE)
}
}

