% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{predict.pre}
\alias{predict.pre}
\title{Predicted values based on final unbiased prediction rule ensemble}
\usage{
\method{predict}{pre}(object, newdata = NULL, type = "link",
  penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}.}

\item{newdata}{optional dataframe of new (test) observations, including all
predictor variables used for deriving the prediction rule ensemble.}

\item{type}{character string. The type of prediction required; the default
\code{type = "link"} is on the scale of the linear predictors. Alternatively,
for count and factor outputs, \code{type = "response"} may be specified to obtain
the fitted mean and fitted probabilities, respectively; \code{type = "class"} 
returns the predicted class membership.}

\item{penalty.par.val}{character or numeric. Penalty parameter criterion 
to be used for selecting final model: lambda giving minimum cv error 
(\code{"lambda.min"}) or lambda giving cv error that is within 1 standard 
error of minimum cv error (\code{"lambda.1se"}). Alternatively, a numeric 
value may be specified, corresponding to one of the values of lambda in the 
sequence used by glmnet,for which estimated cv error can be inspected by running 
\code{object$glmnet.fit} and \code{plot(object$glmnet.fit)}.}

\item{...}{further arguments to be passed to 
\code{\link[glmnet]{predict.cv.glmnet}}.}
}
\description{
\code{predict.pre} generates predictions based on the final prediction rule
ensemble, for training or new (test) observations
}
\details{
If \code{newdata} is not provided, predictions for training data will be 
returned.
}
\examples{
\donttest{
set.seed(1)
train <- sample(1:sum(complete.cases(airquality)), size = 100)
set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),][train,])
predict(airq.ens)
predict(airq.ens, newdata = airquality[complete.cases(airquality),][-train,])}
}
\seealso{
\code{\link{pre}}, \code{\link{plot.pre}}, 
\code{\link{coef.pre}}, \code{\link{importance}}, \code{\link{cvpre}}, 
\code{\link{interact}}, \code{\link{print.pre}}, 
\code{\link[glmnet]{predict.cv.glmnet}}
}
