% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{pre}
\alias{pre}
\title{Derive a prediction rule ensemble}
\usage{
pre(formula, data, type = "both", weights = rep(1, times = nrow(data)),
  sampfrac = 0.5, maxdepth = 3L, learnrate = NULL,
  removeduplicates = TRUE, mtry = Inf, ntrees = 500,
  removecomplements = TRUE, thres = 1e-07, standardize = FALSE,
  winsfrac = 0.025, normalize = TRUE, nfolds = 10L,
  mod.sel.crit = "deviance", verbose = FALSE, par.init = FALSE,
  par.final = FALSE, ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit of the form 
\code{y ~ x1 + x2 + ...+ xn}. If the output variable (left-hand side of the 
formala) is a factor, an ensemble for binary classification is created.
Otherwise, an ensemble for prediction of a continuous variable is created. 
Note that input variables may not have 'rule' as (part of) their name, and 
the formula may not exclude the intercept (that is \code{+ 0} or \code{- 1} 
may not be used in the right-hand side of the formula).}

\item{data}{matrix or data.frame containing the variables in the model. When a
matrix is specified, it must be of class \code{"numeric"} (the input and output 
variable must be continuous; the input variables may be 0-1 coded variables). 
When a data.frame is specified, the output variable must be of 
class \code{"numeric"} and must be a continuous variable; the input variables 
must be of class \code{"numeric"} (for continuous input variables), 
\code{"logical"} (for binary variables), \code{"factor"} (for nominal input 
variables with 2 or more levels), or \code{"ordered" "factor"} (for 
ordered input variables).}

\item{type}{character. Type of base learners to be included in ensemble. 
Defaults to "both" (intial ensemble included both rules and linear functions). 
Other option may be "rules" (for prediction rules only) or "linear" (for 
linear functions only).}

\item{weights}{an optional vector of observation weights to be used for 
deriving the ensemble.}

\item{sampfrac}{numeric value greater than 0 and smaller than or equal to 1. 
Fraction of randomly selected training observations used to produce each 
tree. Values smaller than 1 will result in subsamples being drawn without 
replacement (i.e., subsampling), value equal to 1 will result in bootstrap 
sampling.}

\item{maxdepth}{numeric. Maximal number of conditions in rules.}

\item{learnrate}{numeric. Learning rate for sequentially induced trees. If 
\code{NULL} (default), the learnrate is set to .01 for regression and to 0 
for classification. Setting the learning rate to values > 0 for classification 
dramatically increases computation time.}

\item{removeduplicates}{logical. Remove rules from the ensemble which have 
the exact same support in training data?}

\item{mtry}{numeric. Number of randomly selected predictor variables for 
creating each split in each tree. Ignored for nominal output variables if
\code{learnrate} > 0.}

\item{ntrees}{numeric. Number of trees to generate for the initial ensemble.}

\item{removecomplements}{logical. Remove rules from the ensemble which have
the same support in the training data as the inverse of other rules?}

\item{thres}{numeric. Threshold for convergence.}

\item{standardize}{logical. Standardize rules and linear terms before 
estimating the regression model? As this will also standardize dummy coded
factors, users are adviced to use the default: \code{standardize = FALSE}.}

\item{winsfrac}{numeric. Quantiles of data distribution to be used for 
winsorizing linear terms. If set to 0, no winsorizing is performed. Note 
that ordinal variables are included as linear terms in estimating the
regression model, and will also be winsorized.}

\item{normalize}{logical. Normalize linear variables before estimating the 
regression model? Normalizing gives linear terms the same a priori influence 
as a typical rule.}

\item{nfolds}{numeric. Number of folds to be used in performing cross 
validation for determining penalty parameter.}

\item{mod.sel.crit}{character. Model selection criterion to be used for 
deriving the final ensemble. The default is \code{"deviance"}, which uses 
squared-error for gaussian models (a.k.a. \code{"mse"}) and binomial deviance 
for logistic regression. \code{"class"} would give misclassification error, 
\code{"auc"} would give area under the ROC curve. Further, \code{"mse"} or 
\code{"mae"} (mean squared and mean absolute error) would measure the deviation 
from the fitted mean to the binary or continuous response.}

\item{verbose}{logical. Should information on the initial and final ensemble 
be printed to the command line?}

\item{par.init}{logical. Should parallel foreach be used to generate initial 
ensemble? Only used when \verb{learnrate == 0}. Must register parallel 
beforehand, such as doMC or others.}

\item{par.final}{logical. Should parallel foreach be used to perform cross 
validation for selecting the final ensemble? Must register parallel beforehand, 
such as doMC or others.}

\item{...}{Additional arguments to be passed to 
\code{\link[glmnet]{cv.glmnet}}.}
}
\value{
an object of class \code{pre}
}
\description{
\code{pre} derives a sparse ensemble of rules and/or linear functions for 
prediction of a continuous or binary outcome.
}
\details{
Inputs can be continuous, ordered or factor variables. Output can be
continuous or binary categorical.
}
\note{
The code for deriving rules from the nodes of trees was taken from an 
internal function of the \code{partykit} package of Achim Zeileis and Torsten 
Hothorn.
}
\examples{
\donttest{
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),], verbose = TRUE)}
}

