% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{predict.pre}
\alias{predict.pre}
\title{Predicted values based on final unbiased prediction rule ensemble}
\usage{
\method{predict}{pre}(object, newdata = NULL, type = "link",
  penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}.}

\item{newdata}{optional dataframe of new (test) observations, including all 
predictor variables used for deriving the prediction rule ensemble.}

\item{type}{character string. The type of prediction required; the default
\code{type = "link"} is on the scale of the linear predictors. Alternatively,
for nominal outputs, \code{type = "response"} gives the fitted probabilities
and \code{type = "class"} gives the predicted class membership.}

\item{penalty.par.val}{character. Penalty parameter criterion to be used for 
selecting final model: lambda giving minimum cv error ("lambda.min") or lambda 
giving cv error that is within 1 standard error of minimum cv error 
("lambda.1se").}

\item{...}{currently not used.}
}
\description{
\code{predict.pre} generates predictions based on the final prediction rule 
ensemble, for training or new (test) observations
}
\details{
When newdata is not provided, training data included in the specified 
object is used.
}
\examples{
\donttest{
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
predict(airq.ens, newdata = airquality[complete.cases(airquality),])
predict(airq.ens)}
}

