% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.pqrBayes.R
\name{predict_pqrBayes}
\alias{predict_pqrBayes}
\title{Make predictions from a pqrBayes object}
\usage{
predict_pqrBayes(object, g.new, u.new, e.new, y.new, quant, model, ...)
}
\arguments{
\item{object}{a pqrBayes object.}

\item{g.new}{a matrix of new predictors (e.g. genetic factors) at which predictions are to be made. When being applied to the linear model or group LASSO, g.new = g.}

\item{u.new}{a vector of new environmental factor at which predictions are to be made. When being applied to the linear model or group LASSO, u.new = NULL.}

\item{e.new}{a vector or matrix of new clinical covariates at which predictions are to be made. When being applied to the linear model, e.new = e.}

\item{y.new}{a vector of the response of new observations. When being applied to the linear model or group LASSO, y.new = y.}

\item{quant}{the quantile level.  The default is 0.5.}

\item{model}{the model to be fitted. The default is "VC" for a quantile varying coefficient model. Users can also specify "linear" for a linear model and "group" for a group LASSO.}

\item{...}{other predict arguments}
}
\value{
an object of class `pqrBayes.pred' is returned, which is a list with components:
\item{error}{prediction error.}
\item{y.pred}{predicted values of the new observations.}
}
\description{
Make predictions from a pqrBayes object
}
\details{
g.new (u.new) must have the same number of columns as g (u) used for fitting the model. By default, the clinical covariates are NULL unless 
provided. The predictions are made based on the posterior estimates of coefficients in the pqrBayes object.
}
\examples{
## The quantile regression model
data(data)
data = data$data_linear
g=data$g
y=data$y
e=data$e
fit1=pqrBayes(g,y,u=NULL,e,d = NULL,quant=0.5,spline=NULL,model="linear")
prediction=predict_pqrBayes(fit1,g,u.new=NULL,e.new = e, y.new = y,model="linear")
}
\seealso{
\code{\link{pqrBayes}}
}
