% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data}
\alias{data}
\title{simulated data for demonstrating the features of pqrBayes}
\format{
The data object consists of five components: g, y, u, e and coeff. coeff contains the true values of parameters used for generating the response variable \eqn{y}.
}
\description{
Simulated gene expression data for demonstrating the features of pqrBayes.
}
\details{
\strong{The model for generating Y}

Use subscript \eqn{i} to denote the \eqn{i}th subject. Let \eqn{(\boldsymbol X_{i}, Y_{i}, V_{i}, \boldsymbol E_{i})}, (\eqn{i=1,\ldots,n}) be
independent and identically distributed random vectors. \eqn{Y_{i}} is a continuous response variable representing the
disease phenotype. \eqn{\boldsymbol X_{i}=(X_{i0},...,X_{ip})^\top} denotes a \eqn{(1+p)}--dimensional vector of predictors (e.g. genetic factors) with the first element \eqn{X_{i0}=1}. 
The environmental factor \eqn{V_i \in \rm I\!R^1} is a univariate index variable. \eqn{\boldsymbol E_{i}=(E_{i1},...,E_{iq})^\top} is the \eqn{q}-dimensional vector 
of clinical covariates. At a given quantile level \eqn{\tau},
considering the following quantile varying coefficient model:

\deqn{Y_{i}=\sum_{k=1}^{q} E_{ik} \beta_{k,\tau} +\sum_{j=0}^{p}\gamma_{j,\tau}(V_i)X_{ij} +\epsilon_{i,\tau},}
where \eqn{\beta_{k,\tau}}'s are the regression coefficients for the clinical covariates and \eqn{\gamma_{j,\tau}(\cdot)}'s are unknown smooth varying-coefficient functions. 
The regression coefficients of \eqn{\boldsymbol X} vary with the univariate index variable \eqn{\boldsymbol v=(v_1,...,v_n)^\top}. 
The \eqn{\epsilon_{i,\tau}} is the random error. For simplicity of notation, the quantile level \eqn{\tau} has been suppressed hereafter.


The true model that we used to generate Y:
\deqn{Y_i=\gamma_0(v_i)+\gamma_1(v_i)X_{i1}+\gamma_2(v_i)X_{i2}+\gamma_3(v_i)X_{i3}+\epsilon_i,}
where \eqn{\epsilon_i\sim N(0,1)}, \eqn{\gamma_{0}=1.5\sin(0.2\pi*v_i}), \eqn{\gamma_{1}=2\exp(0.2v_i-1)-1.5 }, \eqn{\gamma_{2}=2-2v_i } and \eqn{\gamma_3=-4+(v_i-2)^3/6}.
}
\examples{
data(data)
g=data$g
dim(g)
coeff=data$coeff
print(coeff)


}
\seealso{
\code{\link{pqrBayes}}
}
\keyword{datasets}
