% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fithp.R
\name{fithp}
\alias{fithp}
\title{Determine the MLE of Hawkes process numerically}
\usage{
fithp(events, end = max(events), vec = c(0.1, 0.2, 0.3))
}
\arguments{
\item{events}{event times}

\item{end}{end of observation period starting from 0 (default last event)}

\item{vec}{vector of initial parameter values}
}
\value{
a hp object indicating the maximum 
likelihood parameter values (lambda0,alpha,beta) for Hawkes process.
This is a non-convex problem and a (unique) solution is not guaranteed.
}
\description{
Determine the MLE of Hawkes process numerically
}
\examples{
hp_obj <- pp_hp(lambda0 = 0.1, alpha = 0.45, beta = 0.5)
sims <- pp_simulate(hp_obj, start = 0, n = 10)
fithp(sims)                  
}
