% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerCompute.R
\name{getPowerMultAM}
\alias{getPowerMultAM}
\alias{getPowerMultTSS}
\title{Functions for computing the power}
\usage{
getPowerMultAM(accept_region, alts_data)

getPowerMultTSS(accept_regions, alt_data)
}
\arguments{
\item{accept_region}{Numeric vector of length two (increasing) setting the
lower and upper limit of the region of acceptance (limits included).}

\item{alts_data}{Numeric matrix with one column of values per alternative
model. If there is only one alternative model, then it can be a simple
vector of values instead (returns a single unnamed value).}

\item{accept_regions}{Numeric matrix with two columns. Each column represents
an interval, i.e., lower and upper limit of the region of acceptance (limits
included), of a different TSS.}

\item{alt_data}{Numeric matrix with one row of values under the
alternative model per TSS.
If there is only one TSS, then it can be a simple vector of values instead
(returns a single unnamed value).}
}
\value{
\code{getPower} A vector containing the power regarding the given
alternative models (retains column names of \code{alts_data}).

\code{getPowerMultTSS} A vector containing the power regarding the
given TSS (retains row names of \code{accept_regions}).
}
\description{
\code{getPowerMultAM} - Computes the power of a single TSS by calculating
the proportion of values outside the region of acceptance for one or multiple
alternative models.

\code{getPowerMultTSS} - Computes the power of one or multiple TSS by
calculating the proportion of values outside the region of acceptance for
a single alternative model.
}
\examples{
getPowerMultAM(accept_region = c(10,20),
         alts_data = matrix(c(9,11,13,15,17,19,21,
                             5, 5, 5,15,25,25,25), ncol = 2, byrow = FALSE,
                           dimnames = list(NULL, c("AltTM1", "AltTM2"))))
getPowerMultAM(accept_region = c(10,20), alts_data = c(9,11,13,15,17,19,21))
getPowerMultTSS(accept_regions = matrix(c(10,20,
                                   110,120), ncol = 2, byrow = TRUE,
                           dimnames = list(c("TSS1", "TSS2"),NULL)),
         alt_data = matrix(c(  9, 14, 19, 24,
                             109,114,119,124), nrow = 2, byrow = TRUE,
                           dimnames = list(c("TSS1", "TSS2"),NULL)))
getPowerMultTSS(accept_regions = c(10,20), alt_data = c(9, 14, 19, 24))
}
