% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regroup.R
\name{regroup}
\alias{regroup}
\title{regroup}
\usage{
regroup(x, ...)
}
\arguments{
\item{x}{A \code{powdRfps} or \code{powdRafps} object}

\item{...}{Other parameters passed to methods e.g. \code{fps.powdRlib}}
}
\value{
a \code{powdRfps} or \code{powdRafps} object with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned)}
\item{residuals}{a vector of the residuals (fitted vs measured)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern}
\item{phases_grouped}{the phases dataframe regrouped according to the supplied data}
\item{rwp}{the Rwp of the fitted vs measured pattern}
\item{weighted_pure_patterns}{a data frame of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
\item{inputs}{a list of input arguments used in the function call}
}
\description{
\code{regroup} allows an alternative grouping structure to be applied to \code{powdRfps}
and \code{powdRafps} objects. For more details see \code{?regroup.powdRfps} or
\code{?regroup.powdRafps}.
}
\details{
\code{powdRfps} and \code{powdRafps} objects contain a data frame called \code{phases_grouped}
that summarises phase concentrations based on defined mineral groups from the \code{powdRlib}
reference library. \code{regroup} allows you to change this grouping structure by supplying
new group identities.
}
\examples{
#Load the minerals library
data(minerals)

#Load the soils data
data(soils)

#Load the regrouping structure
data(minerals_regroup_structure)

\dontrun{
fps_sandstone <- fps(lib = minerals,
                     smpl = soils$sandstone,
                     refs = minerals$phases$phase_id,
                     std = "QUA.1",
                     align = 0.2)

fps_sandstone_regrouped <- regroup(fps_sandstone,
                                   minerals_regroup_structure)

fps_sandstone_regrouped$phases_grouped

}
}
