% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cumul.poth.R
\name{plot.cumul.poth}
\alias{plot.cumul.poth}
\title{Plot cumulative precision of treatment hierarchy (POTH) values}
\usage{
\method{plot}{cumul.poth}(x, labels = FALSE, nchar.trts = 4, digits = 3, ...)
}
\arguments{
\item{x}{R object of class \code{cumul.poth}.}

\item{labels}{A logical indicating whether treatment names should be
shown in the plot.}

\item{nchar.trts}{Number of characters to keep for each treatment name if labels = TRUE.}

\item{digits}{Minimal number of significant digits for cumulative POTH, see
\code{\link{print.default}}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A ggplot2 object.
}
\description{
Plot cumulative precision of treatment hierarchy (POTH) values
}
\details{
Plot results of cumulative method for precision of treatment hierarchy (POTH) metric
(Wigle et al., 2024).
}
\examples{
\donttest{
library("netmeta")
data(Senn2013)
net1 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", random = FALSE)

# Cumulative method
c1 <- cumul(poth(net1))
c1
plot(c1)
plot(c1, labels = TRUE)
c2 <- cumul(poth(net1), sort = FALSE)
c2
plot(c2)
plot(c2, labels = TRUE)
}
}
\references{
Wigle, A., Béliveau, A., Salanti, G., Rücker, G., Schwarzer, G., Mavridis, D.,
Nikolakopoulou, A. (2024):
Precision of Treatment Hierarchy: A Metric for Quantifying Uncertainty in Treatment
Hierarchies in Network Meta-Analysis
}
\author{
Augustine Wigle \email{amhwigle@uwaterloo.ca},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
