% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretchbetaval.R
\name{stretchbetaval}
\alias{stretchbetaval}
\title{Stretched beta-distributed random numbers}
\usage{
stretchbetaval(mn, std, minb, maxb, fx)
}
\arguments{
\item{mn}{mean of a fertility rate}

\item{std}{standard deviation}

\item{minb}{minimum value}

\item{maxb}{maximum value}

\item{fx}{Cumulative Distribution Function value}
}
\value{
Returns a stretched beta number with mean mn, standard deviation std,
minimum and maximum values (minb, maxb) and CDF value fx.
}
\description{
Generate a stretched beta number with mean, standard deviation, minimum and
maximum values and CDF value for bounded fertility estimates
}
\details{
converted Matlab code from Box 8.5 in Morris and Doak (2002)
}
\examples{
stretchbetaval(3, 1.2, 1, 20, runif(1))
# Generates stretchbeta random
# fertilities for a population of 1000 mature individuals (Ni) with mean
# fertility (f) of 3.0 and inter-individual variance in fertility (varF) of 1.5.
Ni   <- 1000
f    <- 2.5
varF <- 1
fmin <- 1
fmax <- 5
rndfert<-numeric(Ni)
for(i in 1:Ni) rndfert[i] <- stretchbetaval(f, sqrt(varF), fmin, fmax, runif(1)) 
hist(rndfert,20, main="Stretched beta-distributed random fertilities",
 xlab="Fertility rate", , col="blue")

}
\references{
Morris, W. F., and D. F. Doak. 2002. Quantitative conservation
biology: Theory and practice of population viability analysis. Sinauer,
Sunderland, Massachusetts, USA.
}
\seealso{
\code{\link{betaval}}
}
\author{
Adapted to R by Patrick Nantel, 11 July 2005.
}
