% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.graph.params.R
\name{generate.graph.params}
\alias{generate.graph.params}
\title{Generate a graph parameter object to fit admixture graph to observed fstats}
\usage{
generate.graph.params(
  graph,
  fstats = NULL,
  popref = NULL,
  outfileprefix = NULL,
  verbose = TRUE
)
}
\arguments{
\item{graph}{A three columns matrix containing graph information in a simple format (see details)}

\item{fstats}{A fstats object containing estimates of fstats}

\item{popref}{Reference population of the fstats basis used to fit the graph.}

\item{outfileprefix}{The prefix of the dot file that will represent the graph (with extension ".dot"). If NULL, no graph file generated}

\item{verbose}{If TRUE some information is printed on the terminal}
}
\value{
An object of class graph.params (see help(graph.params) for details)
}
\description{
Generate a graph parameter object to fit admixture graph to observed fstats
}
\details{
The graph needs to be specified by a three column (character) matrix corresponding for each edge (wether admixed or not) to i) the child node; ii) the parent node; iii) the admixture proportion. For non-admixed edge, the third column must be blank. An admixed node should be referred two times as a child node with two different parent node and two different admixture proportions coded as alpha and (1-alpha) (Note that the parentheses are mandatory) if alpha is the name of the admixture proportion. The root is automatically identified as a node only present in the parent node column. Several checks are made within the function but it is recommended to check the graph by plotting the resulting dot file named {outfileprefix.}dot using for instance the grViz() from the DiagrammeR package that may be called directly with plot or with the dot program (e.g., dot -Tpng inputgraph.dot in terminal). Note that the dot file may be easily customized (e.g., to change leave color, parameter names...). The fstats object should be of class fstats (see help(fstats) for details) containing estimates of F2 and F3 statistics and block jackknife as generated with the \code{\link{compute.fstats}} function with computeF3 set to TRUE. If no fstats object is provided, only graph parameters will be generated.
}
\examples{
graph=rbind(c("P1","P7",""),c("P2","s1",""),c("P3","s2",""),c("P6","S",""),
            c("S","s1","a"),c("S","s2","(1-a)"),c("s2","P8",""),c("s1","P7",""),
            c("P4","P9",""),c("P5","P9",""),c("P7","P8",""),
            c("P8","R",""),c("P9","R","")) 
graph.params=generate.graph.params(graph)
plot(graph.params)
##NOTE: this calls grViz from DiagrammeR which cannot easily be plotted 
#within pdf or other device. To that end the easiest is to output 
#the graph in a dot file (using the outfileprefix argument) and 
#then to use the dot program out of R in a terminal: dot -Tpng inputgraph.dot
}
\seealso{
The object may be used to estimate graph parameters with the function \code{\link{fit.graph}} or to generate files for the qpGraph software with \code{\link{graph.params2qpGraphFiles}}. See also \code{\link{graph.params2symbolic.fstats}} to obtain symbolic representation of Fstats.
}
