% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDP.R
\name{MDP}
\alias{MDP}
\alias{MDP2POMDP}
\title{Define an MDP Problem}
\usage{
MDP(
  states,
  actions,
  transition_prob,
  reward,
  discount = 0.9,
  horizon = Inf,
  start = "uniform",
  name = NA
)

MDP2POMDP(x)
}
\arguments{
\item{states}{a character vector specifying the names of the states.}

\item{actions}{a character vector specifying the names of the available
actions.}

\item{transition_prob}{Specifies the transition probabilities between
states.}

\item{reward}{Specifies the rewards dependent on action, states and
observations.}

\item{discount}{numeric; discount rate between 0 and 1.}

\item{horizon}{numeric; Number of epochs. \code{Inf} specifies an infinite
horizon.}

\item{start}{Specifies in which state the MDP starts.}

\item{name}{a string to identify the MDP problem.}

\item{x}{a \code{MDP} object.}
}
\value{
The function returns an object of class MDP which is list with
the model specification. \code{\link[=solve_MDP]{solve_MDP()}} reads the object and adds a list element called
\code{'solution'}.
}
\description{
Defines all the elements of a MDP problem.
}
\details{
MDPs are similar to POMDPs, however, states are completely observable and
observations are not necessary. The model is defined similar to \link{POMDP}
models, but observations are not specified and the \code{'observations'} column in
the the reward specification is always \code{'*'}.

\code{MDP2POMDP()} reformulates a MDP as a POMDP with one observation per state
that reveals the current state. This is achieved by defining identity
observation probability matrices.

More details on specifying the model components can be found in the documentation
for \link{POMDP}.
}
\examples{
# Michael's Sleepy Tiger Problem is like the POMDP Tiger problem, but
# has completely observable states because the tiger is sleeping in front
# of the door. This makes the problem an MDP.

STiger <- MDP(
  name = "Michael's Sleepy Tiger Problem",
  discount = .9,

  states = c("tiger-left" , "tiger-right"),
  actions = c("open-left", "open-right", "do-nothing"),
  start = "uniform",

  # opening a door resets the problem
  transition_prob = list(
    "open-left" =  "uniform",
    "open-right" = "uniform",
    "do-nothing" = "identity"),

  # the reward helper R_() expects: action, start.state, end.state, observation, value
  reward = rbind(
    R_("open-left",  "tiger-left",  v = -100),
    R_("open-left",  "tiger-right", v =   10),
    R_("open-right", "tiger-left",  v =   10),
    R_("open-right", "tiger-right", v = -100),
    R_("do-nothing",                v =    0)
  )
)

STiger

sol <- solve_MDP(STiger, eps = 1e-7)
sol

policy(sol)
plot_value_function(sol)

# convert the MDP into a POMDP and solve
STiger_POMDP <- MDP2POMDP(STiger)
sol2 <- solve_POMDP(STiger_POMDP)
sol2 

policy(sol2)
plot_value_function(sol2)
}
\seealso{
Other MDP: 
\code{\link{simulate_MDP}()},
\code{\link{solve_MDP}()}
}
\author{
Michael Hahsler
}
\concept{MDP}
