% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opencpu.R
\name{ocpu_exec}
\alias{ocpu_exec}
\alias{opencpu}
\title{Execute code on OpenCPU server}
\usage{
ocpu_exec(fn, corpus, server, restricted = FALSE, do.call = FALSE, ...)
}
\arguments{
\item{fn}{Name of the function/method to execute on remote server (length-one
\code{character} vector).}

\item{corpus}{A length-one \code{character} vector, the id of the corpus to be
queried.}

\item{server}{The IP/URL of the remote OpenCPU server.}

\item{restricted}{A \code{logical} value, whether credentials are required to
access the data.}

\item{do.call}{Logical, if \code{TRUE}, the function \code{fn} is passed into
a call of \code{do.call}, which offers some flexibility.}

\item{...}{Arguments passed into the method/function call.}
}
\description{
\code{ocpu_exec} will execute a function/method \code{fn} on an OpenCPU server
(specified by argument \code{server}), using three dots (\code{...}) to pass
arguments. It is the worker of methods defined for \code{remote_corpus},
\code{remote_subcorpus} and \code{remote_partition} objects.
}
\examples{
\dontrun{
# Get polmineR version installed on remote server
ocpu_exec(
  fn = "packageVersion",
  server = Sys.getenv("OPENCPU_SERVER"),
  do.call = TRUE,
  pkg = "polmineR"
)
}
}
