% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/p_attributes.R, R/partition.R,
%   R/enrich.R
\docType{class}
\name{partition_class}
\alias{partition_class}
\alias{partition-class}
\alias{show,partition-method}
\alias{[,partition,ANY,ANY,ANY-method}
\alias{[,partition-method}
\alias{as.partition_bundle}
\alias{as.partition_bundle,partition-method}
\alias{export}
\alias{export,partition-method}
\alias{split}
\alias{plpr_partition-class}
\alias{press_partition-class}
\alias{p_attributes,partition-method}
\alias{is.partition}
\alias{enrich,partition-method}
\title{Partition class and methods.}
\usage{
\S4method{p_attributes}{partition}(.Object, p_attribute = NULL, ...)

is.partition(x)

\S4method{enrich}{partition}(.Object, p_attribute = NULL, decode = TRUE,
  verbose = TRUE, mc = FALSE, ...)
}
\arguments{
\item{.Object}{a \code{partition} object}

\item{p_attribute}{a p-attribute (for enriching) / performing count.}

\item{...}{further parameters passed into \code{count} when calling \code{enrich}, and ...}

\item{x}{a \code{partition} object}

\item{decode}{\code{logical} value, whether to decode token ids into strings when performing count}

\item{verbose}{\code{logical} value, whether to output messages}

\item{mc}{\code{logical} or, if numeric, providing the number of cores}
}
\description{
The \code{partition} class is used to manage subcorpora. It is an S4 class, and
a set of methods is defined for the class. The class inherits
from the classes \code{count} and \code{textstat}.
}
\details{
As \code{partition} objects inherit from \code{count} and \code{textstat} class, methods
available are \code{view} to inspect the table in the \code{stat} slot, \code{name} and 
\code{name<-} to retrieve/set the name of an object, and more.

The \code{p_attributes}-method returns the p-attributes defined for the
corpus the partition is derived from, if argument \code{p_attribute} is \code{NULL}
(the default). If \code{p_attribute} is defined, the unique values for the p-attribute
are returned.

The \code{is.partition} function returns a \code{logical} value whether \code{x}
is a \code{partition}, or not.

The \code{enrich}-method will add a count of tokens defined by argument
\code{p_attribute} to slot \code{stat} of the \code{partition} object.
}
\section{Slots}{

\describe{
\item{\code{name}}{A name to identify the object (\code{character} vector with length 1); useful when multiple
\code{partition} objects are combined to a \code{partition_bundle}.}

\item{\code{corpus}}{The CWB indexed corpus the partition is derived from (\code{character} vector with length 1).}

\item{\code{encoding}}{Encoding of the corpus (\code{character} vector with length 1).}

\item{\code{s_attributes}}{A named \code{list} with the s-attributes specifying the partition.}

\item{\code{explanation}}{Object of class \code{character}, an explanation of the partition.}

\item{\code{cpos}}{A \code{matrix} with left and right corpus positions defining regions (two columns).}

\item{\code{annotations}}{Object of class \code{list}.}

\item{\code{size}}{Total size of the partition (\code{integer} vector, length 1).}

\item{\code{stat}}{An (optional) \code{data.table} with counts. If present, speeds up computation of cooccurrences,
as count is already present.}

\item{\code{metadata}}{Object of class \code{data.frame}, metadata information.}

\item{\code{strucs}}{Object of class \code{intger}, the strucs defining the partition.}

\item{\code{p_attribute}}{Object of class \code{character} indicating the p_attribute of the
count in slot \code{stat}.}

\item{\code{xml}}{Object of class \code{character}, whether the xml is flat or nested.}

\item{\code{s_attribute_strucs}}{Object of class \code{character} the base node}

\item{\code{call}}{Object of class \code{character} the call that generated the partition}
}}

\seealso{
The \code{partition}-class inherits from the \code{\link{textstat-class}}, see
respective documentation to learn more.
}
\author{
Andreas Blaette
}
