% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_method.R
\docType{methods}
\name{features,partition-method}
\alias{features,partition-method}
\alias{features}
\alias{features,count-method}
\alias{features,partitionBundle-method}
\alias{features,ngrams-method}
\title{Get features by comparison.}
\usage{
\S4method{features}{partition}(x, y, included = FALSE, method = "chisquare",
  verbose = FALSE)

\S4method{features}{count}(x, y, by = NULL, included = FALSE,
  method = "chisquare", verbose = TRUE)

\S4method{features}{partitionBundle}(x, y, included = FALSE,
  method = "chisquare", verbose = TRUE, mc = getOption("polmineR.mc"),
  progress = FALSE)

\S4method{features}{ngrams}(x, y, included = FALSE, method = "chisquare",
  verbose = TRUE, ...)
}
\arguments{
\item{x}{a partition or partitionBundle object}

\item{y}{a partition object, it is assumed that the coi is a subcorpus of
ref}

\item{included}{TRUE if coi is part of ref, defaults to FALSE}

\item{method}{the statistical test to apply (chisquare or log likelihood)}

\item{verbose}{logical, defaults to TRUE}

\item{by}{the columns used for merging, if NULL (default), the pAttribute of
x will be used}

\item{mc}{logical, whether to use multicore}

\item{progress}{logical}

\item{...}{further parameters}
}
\description{
The features of two objects, usually a partition defining a corpus of 
interest, and a partition defining a reference corpus are compared. 
The most important purpose is term extraction.
}
\examples{
use("polmineR")

kauder <- partition(
  "GERMAPARLMINI",
  speaker = "Volker Kauder", interjection = "speech",
  pAttribute="word"
  )
all <- partition("GERMAPARLMINI", interjection = "speech", pAttribute = "word")

terms_kauder <- features(x = kauder, y = all, included = TRUE)
top100 <- subset(terms_kauder, rank_chisquare <= 100)
head(top100)

# a different way is to compare count objects
kauder_count <- as(kauder, "count")
all_count <- as(all, "count")
terms_kauder <- features(kauder_count, all_count, included = TRUE)
top100 <- subset(terms_kauder, rank_chisquare <= 100)
head(top100)

speakers <- partitionBundle("GERMAPARLMINI", sAttribute = "speaker")
speakers <- enrich(speakers, pAttribute = "word")
speaker_terms <- features(speakers[[1:5]], all, included = TRUE, progress = TRUE)
dtm <- as.DocumentTermMatrix(speaker_terms, col = "chisquare")
}
\references{
Manning / Schuetze ...

Baker, Paul (2006): \emph{Using Corpora in Discourse Analysis}. London: continuum, p. 121-149 (ch. 6).

Manning, Christopher D.; Schuetze, Hinrich (1999): \emph{Foundations of Statistical Natural Language
Processing}. MIT Press: Cambridge, Mass., pp. 151-189 (ch. 5).
}
\author{
Andreas Blaette
}
