% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hits.R
\docType{methods}
\name{hits}
\alias{hits}
\alias{hits,character-method}
\alias{hits,partition-method}
\alias{hits,partition_bundle-method}
\alias{hits,context-method}
\title{Get Hits.}
\usage{
hits(.Object, ...)

\S4method{hits}{character}(.Object, query, cqp = FALSE, check = TRUE,
  s_attribute = NULL, p_attribute = "word", size = FALSE,
  freq = FALSE, mc = FALSE, verbose = TRUE, progress = TRUE, ...)

\S4method{hits}{partition}(.Object, query, cqp = FALSE,
  s_attribute = NULL, p_attribute = "word", size = FALSE,
  freq = FALSE, mc = FALSE, progress = FALSE, verbose = TRUE, ...)

\S4method{hits}{partition_bundle}(.Object, query, cqp = FALSE,
  check = TRUE, p_attribute = getOption("polmineR.p_attribute"),
  size = TRUE, freq = FALSE, mc = getOption("polmineR.mc"),
  progress = FALSE, verbose = TRUE, ...)

\S4method{hits}{context}(.Object, s_attribute = NULL, verbose = TRUE,
  ...)
}
\arguments{
\item{.Object}{a character, \code{partition} or \code{partition_bundle} object}

\item{...}{further parameters}

\item{query}{a (optionally named, see datails) character vector with one or more queries}

\item{cqp}{either logical (TRUE if query is a CQP query), or a
function to check whether query is a CQP query or not}

\item{check}{A \code{logical} value, whether to check validity of CQP query
using \code{check_cqp_query}.}

\item{s_attribute}{s-attributes}

\item{p_attribute}{p-attribute}

\item{size}{logical - return size of subcorpus}

\item{freq}{logcial - return relative frequencies}

\item{mc}{logical, whether to use multicore}

\item{verbose}{logical}

\item{progress}{logical, whether to show progress bar}
}
\description{
Get hits for a (set of) queries, optionally with s-attribute values.
}
\details{
If the query character vector is named, the names of the query occurr in
the data.table that is returned rather than the queries.

If freq is TRUE, the data.table returned in the DT-slot will deliberately
include the subsets of the partition/corpus with no hits (query is NA,
count is 0).
}
