% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion_method.R
\docType{methods}
\name{dispersion}
\alias{dispersion}
\alias{dispersion,character-method}
\alias{dispersion,hits-method}
\alias{dispersion,partition-method}
\title{Dispersion of a query or multiple queries}
\usage{
dispersion(.Object, ...)

\S4method{dispersion}{partition}(.Object, query, sAttribute, cqp = FALSE,
  pAttribute = getOption("polmineR.pAttribute"), freq = FALSE, mc = FALSE,
  progress = TRUE, verbose = FALSE)

\S4method{dispersion}{character}(.Object, query, sAttribute, cqp = FALSE,
  pAttribute = getOption("polmineR.pAttribute"), freq = FALSE, mc = FALSE,
  progress = TRUE, verbose = TRUE)

\S4method{dispersion}{hits}(.Object, sAttribute, freq = FALSE)
}
\arguments{
\item{.Object}{a partition object}

\item{...}{further parameters}

\item{query}{a character vector containing one or multiple queries}

\item{sAttribute}{a character vector of length 1 or 2 providing the sAttributes}

\item{cqp}{if logical, whether the query is a CQP query (TRUE/FALSE), if it is a function that is passed in, the function will be applied to the query to guess whether query is a CQP query}

\item{pAttribute}{the p-attribute that will be looked up, typically 'word'
or 'lemma'}

\item{freq}{logical, whether to calculate normalized frequencies}

\item{mc}{logical, whether to use multicore}

\item{progress}{logical, whether to shop progress}

\item{verbose}{logical, whether to be verbose}
}
\value{
depends on the input, as this is a wrapper function
}
\description{
The function returns the frequencies of a query or a multiple queries
in sub-partitions defined by one or two dimensions. This is a wrapper function, so the output will depend
on the number of queries and dimensions provided.
}
\examples{
\dontrun{
  use("polmineR.sampleCorpus")
  test <- partition("PLPRBTTXT", text_year = "2009", pAttribute = NULL)
  integration <- dispersion(
    test, query = "Integration",
    pAttribute = "word", sAttribute = "text_date"
    )
  integration <- dispersion(
    test, "Integration",
    sAttribute = c("text_date", "text_party")
    )
  integration <- dispersion(
    test, '"Integration.*"',
    sAttribute = "text_year", cqp = TRUE
    )
}
}
\author{
Andreas Blaette
}
\seealso{
\code{crosstab-class}

count
}

