% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions__lazy.R
\name{pl_sum}
\alias{pl_sum}
\title{sum across expressions / literals / Series}
\arguments{
\item{...}{is a:
If one arg:
\itemize{
\item Series or Expr, same as \code{column$sum()}
\item string, same as \code{pl$col(column)$sum()}
\item numeric, same as \code{pl$lit(column)$sum()}
\item list of strings(column names) or expressions to add up as expr1 + expr2 + expr3 + ...
}

If several args, then wrapped in a list and handled as above.}
}
\value{
Expr
}
\description{
syntactic sugar for starting a expression with sum
}
\examples{
# column as string
pl$DataFrame(iris)$select(pl$sum("Petal.Width"))

# column as Expr (prefer pl$col("Petal.Width")$sum())
pl$DataFrame(iris)$select(pl$sum(pl$col("Petal.Width")))

# column as numeric
pl$DataFrame()$select(pl$sum(1:5))


df = pl$DataFrame(a = 1:2, b = 3:4, c = 5:6)

# column as list
df$with_column(pl$sum(list("a", "c")))
df$with_column(pl$sum(list("a", "c", 42L)))

# two eqivalent lines
df$with_column(pl$sum(list(pl$col("a") + pl$col("b"), "c")))
df$with_column(pl$sum(list("*")))
}
\keyword{Expr_new}
