% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{pl_from_arrow}
\alias{pl_from_arrow}
\alias{from_arrow}
\title{from_arrow}
\arguments{
\item{data}{arrow Table or Array or ChunkedArray}

\item{rechunk}{bool rewrite in one array per column, Implemented for ChunkedArray
Array is already contiguous. Not implemented for Table. C}

\item{schema}{named list of DataTypes or char vec of names. Same length as arrow table.
If schema names or types do not match arrow table, the columns will be renamed/recast.
NULL default is to import columns as is. Takes no effect for Array or ChunkedArray}

\item{schema_overrides}{named list of DataTypes. Name some columns to recast by the DataType.
Takes not effect for Array or ChunkedArray}
}
\value{
DataFrame or Series
}
\description{
import Arrow Table or Array
}
\examples{
pl$from_arrow(
  data = arrow::arrow_table(iris),
  schema_overrides = list(Sepal.Length = pl$Float32, Species = pl$Utf8)
)

char_schema = names(iris)
char_schema[1] = "Alice"
pl$from_arrow(
  data = arrow::arrow_table(iris),
  schema = char_schema
)
}
\keyword{pl}
