skip_on_cran()

test_that("column roles can be satisfactorily determined", {

  expect_equal(
    get_column_roles(gt::countrypops),
    c(
      "country:iso3166-1-esn.string.categorical",
      "country:iso3166-1-a-2.string.categorical", 
      "country:iso3166-1-a-3.string.categorical",
      "integer.discrete", 
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(gt::sza),
    c(
      "geo:latitude.numeric.discrete",
      "string.categorical",
      "string.categorical", 
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(gt::gtcars),
    c(
      "string",
      "string",
      "numeric.continuous",
      "string",
      "string",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "string",
      "string",
      "country:iso3166-1-esn.string.categorical",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(gt::sp500),
    c(
      "date.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.discrete",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(gt::pizzaplace),
    c(
      "id.string",
      "date.string",
      "string",
      "string.categorical",
      "string.categorical",
      "string.categorical",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(gt::exibble),
    c(
      "numeric.continuous",
      "string",
      "string.categorical",
      "date.string",
      "string",
      "string",
      "numeric.continuous",
      "string",
      "string"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::diamonds),
    c(
      "numeric.continuous",
      "string.ordinal",
      "string.ordinal",
      "string.ordinal",
      "numeric.continuous",
      "numeric.continuous",
      "integer.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::economics),
    c(
      "date.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.discrete"  
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::economics_long),
    c(
      "date.discrete",
      "string.categorical",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::faithfuld),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::luv_colours),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "string"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::midwest),
    c(
      "integer.discrete",
      "string",
      "country_subd:iso3166-2.string.categorical",
      "numeric.continuous",
      "integer.discrete",
      "numeric.continuous",
      "integer.discrete",
      "integer.discrete",
      "integer.discrete",
      "integer.discrete",
      "integer.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "integer.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "integer.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "integer.discrete",
      "string.categorical"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::mpg),
    c(
      "string.categorical",
      "string.categorical",
      "numeric.continuous",
      "integer.discrete",
      "integer.discrete",
      "string.categorical",
      "string.categorical",
      "integer.discrete",
      "integer.discrete",
      "string.categorical",
      "string.categorical"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::msleep),
    c(
      "string",
      "string",
      "string",
      "string",
      "string",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::presidential),
    c(
      "string",
      "date.discrete",
      "date.discrete",
      "string"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::seals),
    c(
      "geo:latitude.numeric.continuous",
      "geo:longitude.numeric.continuous",
      "geo:longitude.numeric.continuous",
      "geo:latitude.numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(ggplot2::txhousing),
    c(
      "string.categorical",
      "integer.discrete",
      "integer.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(dplyr::band_instruments),
    c(
      "string",
      "string"
    )
  )
  
  expect_equal(
    get_column_roles(dplyr::band_members),
    c(
      "string",
      "string"
    )
  )
  
  expect_equal(
    get_column_roles(dplyr::starwars),
    c(
      "string",
      "integer.discrete",
      "numeric.continuous",
      "string",
      "string",
      "string",
      "numeric.continuous",
      "string",
      "string",
      "string",
      "string",
      "list_object",
      "list_object",
      "list_object"
    )
  )
  
  expect_equal(
    get_column_roles(dplyr::storms),
    c(
      "string",
      "numeric.discrete",
      "numeric.discrete",
      "integer.discrete",
      "numeric.discrete",
      "geo:latitude.numeric.continuous",
      "geo:longitude.numeric.continuous",
      "string.categorical",
      "numeric.discrete",
      "integer.discrete",
      "integer.discrete",
      "integer.discrete",
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::billboard),
    c(
      "string", "string",
      "date.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical",
      "boolean.logical.categorical"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::construction),
    c(
      "numeric.continuous",
      "string",
      "numeric.continuous",
      "boolean.logical.categorical",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::fish_encounters),
    c(
      "string.categorical",
      "string.categorical",
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::population),
    c(
      "country:iso3166-1-esn.string.categorical",
      "numeric.discrete",
      "numeric.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::relig_income),
    c(
      "string",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::smiths),
    c(
      "string",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::us_rent_income),
    c(
      "string",
      "country_subd:iso3166-2-sn[USA].string.categorical",
      "string",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::who),
    c(
      "country:iso3166-1-esn.string.categorical",
      "country:iso3166-1-a-2.string.categorical",
      "country:iso3166-1-a-3.string.categorical",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete",
      "numeric.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(tidyr::world_bank_pop),
    c(
      "string",
      "string.categorical",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(lubridate::lakers),
    c(
      "integer.discrete",
      "string.categorical",
      "string.categorical",
      "string",
      "integer.discrete",
      "string.categorical",
      "string.categorical",
      "string",
      "string.categorical",
      "integer.discrete",
      "string.categorical",
      "integer.discrete",
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::airquality),
    c(
      "integer.discrete",
      "integer.discrete",
      "numeric.continuous",
      "integer.discrete",
      "integer.discrete",
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::cars),
    c(
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::chickwts),
    c(
      "numeric.continuous",
      "string.categorical"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::faithful),
    c(
      "numeric.continuous",
      "numeric.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::iris),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "string.categorical"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::LifeCycleSavings),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::longley),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "integer.discrete",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::morley),
    c(
      "integer.discrete",
      "integer.discrete",
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::mtcars),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::Orange),
    c(
      "string.ordinal",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::pressure),
    c(
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::quakes),
    c(
      "geo:latitude.numeric.continuous",
      "geo:longitude.numeric.continuous",
      "integer.discrete",
      "numeric.continuous",
      "integer.discrete"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::rock),
    c(
      "integer.discrete",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::sleep),
    c(
      "numeric.continuous",
      "string.categorical",
      "string.categorical"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::swiss),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "integer.discrete",
      "integer.discrete",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
  
  expect_equal(
    get_column_roles(datasets::USJudgeRatings),
    c(
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous",
      "numeric.continuous"
    )
  )
})
