% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{snip_lowest}
\alias{snip_lowest}
\title{A \code{fn} for \code{info_snippet()}: get the lowest value from a column}
\usage{
snip_lowest(column)
}
\arguments{
\item{column}{The name of the column that contains the target values.}
}
\value{
A formula needed for \code{\link[=info_snippet]{info_snippet()}}'s \code{fn} argument.
}
\description{
The \code{snip_lowest()} function can be used as an \code{\link[=info_snippet]{info_snippet()}} function
(i.e., provided to \code{fn}) to get the lowest numerical, time value, or
alphabetical value from a column in the target table.
}
\section{Examples}{


Generate an informant object, add a snippet with \code{\link[=info_snippet]{info_snippet()}} and
\code{snip_lowest()} (giving us a method to get the lowest value in column \code{a}).
Define a location for the snippet result in \code{{ }} and then \code{\link[=incorporate]{incorporate()}}
the snippet into the info text. Note here that the order of the
\code{\link[=info_columns]{info_columns()}} and \code{\link[=info_snippet]{info_snippet()}} calls doesn't matter.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <- 
  create_informant(
    tbl = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\% 
  info_columns(
    columns = "a",
    `Lowest Value` = "Lowest value is \{lowest_a\}."
  ) \%>\%
  info_snippet(
    snippet_name = "lowest_a",
    fn = snip_lowest(column = "a")
  ) \%>\%
  incorporate()
}\if{html}{\out{</div>}}

We can print the \code{informant} object to see the information report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_snip_lowest_1.png" alt="This image was generated from the first code example in the `snip_lowest()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

3-8
}

\seealso{
Other Information Functions: 
\code{\link{info_columns_from_tbl}()},
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()},
\code{\link{snip_highest}()},
\code{\link{snip_list}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
