% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{game_revenue}
\alias{game_revenue}
\title{A table with game revenue data}
\format{
A tibble with 2,000 rows and 11 variables:
\describe{
\item{player_id}{A \code{character} column with unique identifiers for each
user/player.}
\item{session_id}{A \code{character} column that contains unique identifiers for
each player session.}
\item{session_start}{A date-time column that indicates when the session
(containing the revenue event) started.}
\item{time}{A date-time column that indicates exactly when the player
purchase (or revenue event) occurred.}
\item{item_type}{A \code{character} column that provides the class of the item
purchased.}
\item{item_name}{A \code{character} column that provides the name of the item
purchased.}
\item{item_revenue}{A \code{numeric} column with the revenue amounts per item
purchased.}
\item{session_duration}{A \code{numeric} column that states the length of the
session (in minutes) for which the purchase occurred.}
\item{start_day}{A \code{Date} column that provides the date of first login for
the player making a purchase.}
\item{acquisition}{A \code{character} column that provides the method of
acquisition for the player.}
\item{country}{A \code{character} column that provides the probable country of
residence for the player.}
}
}
\usage{
game_revenue
}
\description{
This table is a subset of the \code{sj_all_revenue} table from the \strong{intendo}
data package. It's the first 2,000 rows from that table where revenue records
range from \code{2015-01-01} to \code{2015-01-21}.
}
\section{Function ID}{

14-4
}

\examples{
# Here is a glimpse at the data
# available in `game_revenue`
dplyr::glimpse(game_revenue)

}
\seealso{
Other Datasets: 
\code{\link{game_revenue_info}},
\code{\link{small_table_sqlite}()},
\code{\link{small_table}},
\code{\link{specifications}}
}
\concept{Datasets}
\keyword{datasets}
