% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationManager.R
\name{SimulationManager}
\alias{SimulationManager}
\title{R6 class representing a simulation manager.}
\description{
\code{\link[R6:R6Class]{R6}} class to represent a manager for running multiple model
simulations and saving results.

# U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
raster::plot(region$region_raster, main = "Example region (indices)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")
# Example population model template
model_template <- PopulationModel$new(region = region,
                                      time_steps = 10, # years
                                      populations = region$region_cells, # 7
                                      stage_matrix = 1)
# Example generators for initial abundance and carrying capacity
hs_matrix <- c(0.5, 0.3, 0.7, 0.9, 0.6, 0.7, 0.8)
initial_gen <- Generator$new(description = "initial abundance",
                             region = region,
                             hs_matrix = hs_matrix, # template attached
                             inputs = c("initial_n"),
                             outputs = c("initial_abundance"))
initial_gen$add_generative_requirements(list(initial_abundance = "function"))
initial_gen$add_function_template("initial_abundance",
                                  function_def = function(params) {
                                    stats::rmultinom(1, size = params$initial_n,
                                                     prob = params$hs_matrix)[, 1]
                                  },
                                  call_params = c("initial_n", "hs_matrix"))
capacity_gen <- Generator$new(description = "carrying capacity",
                              region = region,
                              hs_matrix = hs_matrix, # template attached
                              inputs = c("density_max"),
                              outputs = c("carrying_capacity"))
capacity_gen$add_generative_requirements(list(carrying_capacity = "function"))
capacity_gen$add_function_template("carrying_capacity",
                                   function_def = function(params) {
                                     round(params$density_max*params$hs_matrix)
                                   },
                                   call_params = c("density_max", "hs_matrix"))
# Sample input parameters
sample_data <- data.frame(initial_n = c(40, 60, 80), density_max = c(15, 20, 25))
# Simulation manager
sim_manager <- SimulationManager$new(sample_data = sample_data,
                                     model_template = model_template,
                                     generators = list(initial_gen, capacity_gen),
                                     parallel_cores = 2,
                                     results_dir = tempdir())
run_output <- sim_manager$run()
run_output$summary
dir(tempdir(), "*.RData") # includes 3 result files
for (i in 1:3) {
  print(paste("Run", i, "results:"))
  file_name <- paste0(sim_manager$get_results_filename(i), ".RData")
  print(readRDS(file.path(tempdir(), file_name)))
}
dir(tempdir(), "*.txt") # plus simulation log
}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericManager]{poems::GenericManager}} -> \code{SimulationManager}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sample_data}}{A data frame of sampled parameters for each simulation/result.}

\item{\code{model_template}}{A \code{\link{SimulationModel}} (or inherited class) object with parameters common to all simulations.}

\item{\code{nested_model}}{A \code{\link{SimulationModel}} (or inherited class) object with empty sample parameters and a nested model template common to all simulations.}

\item{\code{generators}}{A list of generators (\code{\link{Generator}} or inherited class) objects for generating simulation model values.}

\item{\code{model_simulator}}{A \code{\link{ModelSimulator}} (or inherited class) object for running the simulations.}

\item{\code{parallel_cores}}{Number of cores for running the simulations in parallel.}

\item{\code{results_dir}}{Results directory path.}

\item{\code{results_ext}}{Result file extension (default is .RData).}

\item{\code{results_filename_attributes}}{A vector of: prefix (optional); attribute names (from the sample data frame); postfix (optional); utilized to construct results filenames.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SimulationManager$new()}}
\item \href{#method-run}{\code{SimulationManager$run()}}
\item \href{#method-set_model_sample}{\code{SimulationManager$set_model_sample()}}
\item \href{#method-log_simulation}{\code{SimulationManager$log_simulation()}}
\item \href{#method-clone}{\code{SimulationManager$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericClass" data-id="new_clone">}\href{../../poems/html/GenericClass.html#method-new_clone}{\code{poems::GenericClass$new_clone()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericManager" data-id="get_attribute">}\href{../../poems/html/GenericManager.html#method-get_attribute}{\code{poems::GenericManager$get_attribute()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericManager" data-id="get_message_sample">}\href{../../poems/html/GenericManager.html#method-get_message_sample}{\code{poems::GenericManager$get_message_sample()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericManager" data-id="get_results_filename">}\href{../../poems/html/GenericManager.html#method-get_results_filename}{\code{poems::GenericManager$get_results_filename()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets any included attributes (\emph{sample_data}, \emph{model_template}, \emph{generators}, \emph{model_simulator}, \emph{parallel_cores}, \emph{results_dir}, \emph{results_filename_attributes}) and attaches other attributes individually listed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationManager$new(model_template = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_template}}{A SimulationModel (or inherited class) object with parameters common to all simulations.}

\item{\code{...}}{Parameters listed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
Runs the multiple population simulations (via the set function), stores the results, and creates/writes a simulation log.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationManager$run(results_dir = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{results_dir}}{Results directory path (must be present if not already set within manager class object).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Simulator log as a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_model_sample"></a>}}
\if{latex}{\out{\hypertarget{method-set_model_sample}{}}}
\subsection{Method \code{set_model_sample()}}{
Sets the model sample attributes via the sample data frame and the generators.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationManager$set_model_sample(model, sample_index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{\code{\link{SimulationModel}} (or inherited class) object (clone) to receive sample attributes.}

\item{\code{sample_index}}{Index of sample from data frame.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-log_simulation}{}}}
\subsection{Method \code{log_simulation()}}{
Summarizes the simulation log generated within the run method and writes it to a text file in the results directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationManager$log_simulation(simulation_log)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simulation_log}}{Nested list of simulation log entries generated via the run method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimulationManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
