tmp_file <- tempfile()
teardown(unlink(tmp_file))

test_that("save_pmml() outputs correct marker for Zementis Server", {
  iris_lm <- lm(Sepal.Length ~ ., data = iris)
  iris_lm_pmml <- pmml(iris_lm)
  save_pmml(iris_lm_pmml, tmp_file)
  loaded_pmml <- xmlParse(file = tmp_file)
  expect_equal(capture.output(loaded_pmml)[2], "<!--(Comment generated by ADAPA) PMML processed by ADAPA (Version : 4.4)-->")
})
