% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getsda}
\alias{getsda}
\title{Perform structure/reaction directed analysis for peaks list.}
\usage{
getsda(list, rtcutoff = 10, freqcutoff = 10, top = 50,
  corcutoff = NULL, digits = 2, accuracy = 4)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{freqcutoff}{cutoff of frequency of PMDs between RT cluster for peaks, default 10}

\item{top}{top n pmd freqency cutoff when the freqcutoff is too small for large data set, default 50}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}
}
\value{
list with tentative isotope, adducts, and neutral loss peaks' index, retention time clusters.
}
\description{
Perform structure/reaction directed analysis for peaks list.
}
\examples{
data(spmeinvivo)
pmd <- getpaired(spmeinvivo)
std <- getstd(pmd)
sda <- getsda(std)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{plotpaired}}
}
