% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_exports.R
\name{api_create}
\alias{api_create}
\alias{api_create.plotly}
\alias{api_create.ggplot}
\alias{api_create.data.frame}
\alias{api_download_plot}
\alias{api_download_grid}
\alias{api}
\title{Tools for working with plotly's REST API (v2)}
\usage{
api_create(x = last_plot(), filename = NULL, fileopt = c("overwrite",
  "new"), sharing = c("public", "private", "secret"), ...)

\method{api_create}{plotly}(x = last_plot(), filename = NULL,
  fileopt = "overwrite", sharing = "public", ...)

\method{api_create}{ggplot}(x = last_plot(), filename = NULL,
  fileopt = "overwrite", sharing = "public", ...)

\method{api_create}{data.frame}(x, filename = NULL, fileopt = "overwrite",
  sharing = "public", ...)

api_download_plot(id, username)

api_download_grid(id, username)

api(endpoint = "/", verb = "GET", body = NULL, ...)
}
\arguments{
\item{x}{An R object to hosted on plotly's web platform. 
Can be a plotly/ggplot2 object or a \link{data.frame}.}

\item{filename}{character vector naming file(s). If \code{x} is a plot,
can be a vector of length 2 naming both the plot AND the underlying grid.}

\item{fileopt}{character string describing whether to "overwrite" existing 
files or ensure "new" file(s) are always created.}

\item{sharing}{If 'public', anyone can view this graph. It will appear in 
your profile and can appear in search engines. You do not need to be
logged in to Plotly to view this chart.
If 'private', only you can view this plot. It will not appear in the
Plotly feed, your profile, or search engines. You must be logged in to 
Plotly to view this graph. You can privately share this graph with other 
Plotly users in your online Plotly account and they will need to be logged 
in to view this plot.
If 'secret', anyone with this secret link can view this chart. It will
not appear in the Plotly feed, your profile, or search engines. 
If it is embedded inside a webpage or an IPython notebook, anybody who is 
viewing that page will be able to view the graph. 
You do not need to be logged in to view this plot.}

\item{...}{For \code{api()}, these arguments are passed onto 
\code{\link[httr]{VERB}()}. For \code{api_create()}, these arguments are
included in the body of the HTTP request.}

\item{id}{a filename id.}

\item{username}{a plotly username.}

\item{endpoint}{the endpoint (i.e., location) for the request. 
To see a list of all available endpoints, call \code{api()}.
Any relevant query parameters should be included here (see examples).}

\item{verb}{name of the HTTP verb to use (as in, \code{\link[httr]{VERB}()}).}

\item{body}{body of the HTTP request(as in, \code{\link[httr]{VERB}()}).
If this value is not already converted to JSON 
(via \code{\link[jsonlite]{toJSON}()}), it uses the internal \code{to_JSON()}
to ensure values are "automatically unboxed" (i.e., vec.}
}
\description{
Convenience functions for working with version 2 of plotly's REST API.
Upload R objects to a plotly account via \code{api_create()} and download
plotly objects via \code{api_download_plot()}/\code{api_download_grid()}.
For anything else, use \code{api()}.
}
\examples{

\dontrun{

# ------------------------------------------------------------
# api_create() makes it easy to upload ggplot2/plotly objects
# and/or data frames to your plotly account
# ------------------------------------------------------------

# A data frame creates a plotly "grid". Printing one will take you 
# to the it's web address so you can start creating!
(m <- api_create(mtcars))

# A plotly/ggplot2 object create a plotly "plot".
p <- plot_ly(mtcars, x = ~factor(vs))
(r <- api_create(p))

# api_create() returns metadata about the remote "file". Here is
# one way you could use that metadata to download a plot for local use:
fileID <- strsplit(r$file$fid, ":")[[1]]
layout(
  api_download_plot(fileID[2], fileID[1]),
  title = sprintf("Local version of <a href='\%s'>this</a> plot", r$file$web_url)
)

------------------------------------------------------------
# The api() function provides a low-level interface for performing 
# any action at any endpoint! It always returns a list.
# ------------------------------------------------------------

# list all the endpoints
api()

# search the entire platform!
# see https://api.plot.ly/v2/search
api("search?q=overdose")
api("search?q=plottype:pie trump fake")

# these examples will require a user account
usr <- Sys.getenv("plotly_username", NA)
if (!is.na(usr)) {
  # your account info https://api.plot.ly/v2/#users
  api(sprintf("users/\%s", usr))
  # your folders/files https://api.plot.ly/v2/folders#user
  api(sprintf("folders/home?user=\%s", usr))
}

# Retrieve a specific file https://api.plot.ly/v2/files#retrieve
api("files/cpsievert:14681")

# change the filename https://api.plot.ly/v2/files#update
# (note: this won't work unless you have proper credentials to the relevant account)
api("files/cpsievert:14681", "PATCH", list(filename = "toy file")) 

# Copy a file https://api.plot.ly/v2/files#lookup
api("files/cpsievert:14681/copy", "POST")

# Create a folder https://api.plot.ly/v2/folders#create
api("folders", "POST", list(path = "/starts/at/root/and/ends/here"))

}

}
\references{
\url{https://api.plot.ly/v2}
}
\seealso{
\code{\link{signup}()}
}
\author{
Carson Sievert
}
