% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_alpha.R
\name{raster_alpha}
\alias{raster_alpha}
\title{Combine a Matrix of Colors and 
a Matrix of Alpha Values}
\usage{
raster_alpha(color, alpha)
}
\arguments{
\item{color}{a matrix of colors, a 
raster or an image read into R by 
\code{magick::image_read}.}

\item{alpha}{either a single value (e.g., 0.4)
or a matrix of alpha values. The matrix 
should have the same numbers of rows 
and columns as \code{color}.}
}
\description{
The function is a wrapper of 
\code{scales::alpha}. While the latter 
only works on vectors, the former 
can combine a matrix of colors and 
a matrix of alpha values as long as the two 
have the same numbers of rows and 
columns.
}
\examples{
# A color matrix
co=c("red", "yellow", "green", "blue")
co=rbind(co, co, co)
# An alpha matrix
alp=c(1, 0.6, 0.3, 0.1)
alp=rbind(alp, alp, alp)
# Now combine the two
result=raster_alpha(co, alp)
}
