% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rect_cm.R
\name{geom_rect_cm}
\alias{geom_rect_cm}
\title{Geom Layer for Rectangle with Absolute Size}
\usage{
geom_rect_cm(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{aes mapping.}

\item{data}{data.}

\item{stat}{stat.}

\item{position}{position.}

\item{na.rm}{logical, whether to remove NA values.}

\item{show.legend}{whether to show legend.}

\item{inherit.aes}{logical, whether to inherit aes from ggplot().}

\item{...}{additional parameters.}
}
\description{
This layer uses centimeter as unit to draw rectangles so 
that the size and shape will not be influenced by 
the coordinate systems 
(even when a polar system is used).
}
\details{
Accepted properties are: 
\itemize{
  \item (1) \code{width} width in centimeter.
  \item (2) \code{height} height in centimeter.
  \item (3) \code{color} color of the outline.
  \item (4) \code{fill} color inside the shape.
  \item (5) \code{alpha} alpha of color and fill.
  \item (6) \code{size} line width of outline.
  \item (7) \code{linetype} line type.
  \item (8) \code{hjust} horizontal adjustment, 
default is 0.5 which means no adjustment.
  \item (9) \code{vjust} vertical adjustment, 
default is 0.5 which means no adjustment.
  \item (10) \code{x} x coordinates of middle points. 
  \item (11) \code{y} y coordinates of middle points.
}
}
\examples{
library(ggplot2)
ggplot()+xlim(-0.5, 10.5)+
	geom_rect_cm(aes(x=1: 10, y=rep(4, 10)), fill="red", height=rep(1: 2, each=5), 
		vjust=rep(c(0, 0.5), 5))+
	geom_point(aes(x=1: 10, y=rep(4, 10)), color="green")
}
