% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeltaB2pc.R
\name{DeltaB2pc}
\alias{DeltaB2pc}
\alias{DeltaB2pc_cat3logit}
\alias{DeltaB2pc_cat3logit_dim1}
\alias{DeltaB2pc_cat3logit_dim2}
\alias{DeltaB2pc_cat3logit_dim3}
\alias{DeltaB2pc_ord3logit}
\title{Identification of equispaced central points}
\usage{
DeltaB2pc_cat3logit(DeltaB, n = 8, edge = 0.01)

DeltaB2pc_cat3logit_dim1(DeltaB, n, edge)

DeltaB2pc_cat3logit_dim2(DeltaB, n, edge)

DeltaB2pc_cat3logit_dim3(DeltaB, n, edge)

DeltaB2pc_ord3logit(DeltaB, alpha, n = 8, edge = 0.01)
}
\arguments{
\item{DeltaB}{either a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 2}}
or a vector of length 2, if the model is \emph{categorical}; otherwise
a matrix \eqn{\Delta^TB\in\textbf{R}^{1\times 1}} or a \code{numeric},
if the model is \emph{ordinal}.}

\item{n}{number of points (curves of the field).}

\item{edge}{width of the border of the ternary plot.}
}
\value{
A named \code{list} with three components:

\item{status}{a \code{character} which may be either equal to
\code{"p0"} or \code{"pc"}. The former value (\code{"p0"}) is taken
when the point is the origin of the curve, whereas
the latter (\code{"pc"}) means that the point is \emph{over} the
curve, and the origin should be computed (see
\code{\link{pc2p0}}).}
\item{fo}{the filter of the sides where the field
originates from.}
\item{pp}{a \code{list} of ternary coordinates.}
}
\description{
Given the effect \eqn{\Delta^TB\in\textbf{R}^{1\times 2}} of a change
\eqn{\Delta\in\textbf{R}^k} in the vector of covariates
\eqn{x\in\textbf{R}^k} on the linear predictor
\eqn{x^TB\in\textbf{R}^{n\times 2}}, it computes
the set of points that makes the curves of the field equally spaced.
}
\keyword{internal}
