% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_granger.R
\name{pgrangertest}
\alias{pgrangertest}
\title{Panel Granger (Non-)Causality Test (Dumitrescu/Hurlin (2012))}
\usage{
pgrangertest(formula, data, test = c("Ztilde", "Zbar", "Wbar"),
  order = 1L, index = NULL)
}
\arguments{
\item{formula}{a \code{formula} object to describe the direction of the
hypothesized Granger causation,}

\item{data}{a \code{pdata.frame} or a \code{data.frame},}

\item{test}{a character to request the statistic to be returned,
either \code{"Ztilde"} (default), or \code{"Zbar"},}

\item{order}{integer(s) giving the number of lags to include in the
test's auxiliary regressions, the length of order must be
either 1 (same lag order for all individuals) or equal to the
number of individuals (to specify a lag order per individual),}

\item{index}{only relevant if \code{data} is \code{data.frame} and not a
\code{pdata.frame}; if \code{NULL}, the first two columns of the
data.frame are assumed to be the index variables, for further
details see \code{\link[=pdata.frame]{pdata.frame()}}.}
}
\value{
An object of class \code{c("pgrangertest", "htest")}. Besides
the usual elements of a \code{htest} object, it contains the data
frame \code{indgranger} which carries the Granger test statistics
per individual along the associated p-values, degrees of
freedom and the specified lag order.
}
\description{
Test for Granger (non-)causality in panel data.
}
\details{
% TODO: write about assumptions of panel Granger test: % * cross-sectional
independence % * convergence

The panel Granger (non-)causality test is a combination of Granger
tests \insertCite{GRAN:69}{plm} performed per individual. The test
is developed by \insertCite{DUMI:HURL:12;textual}{plm}, a shorter
exposition is given in \insertCite{LOPE:WEBE:17;textual}{plm}.

The formula \code{formula} describes the direction of the (panel) Granger
causation where \code{y ~ x} means "x (panel) Granger causes y".

By setting argument \code{test} to either \code{"Ztilde"} (default) or
\code{"Zbar"}, two different statistics can be requested. \code{"Ztilde"}
gives the standardised statistic recommended by Dumitrescu/Hurlin (2012) for
fixed T samples. If set to \code{"Wbar"}, the intermediate Wbar statistic
(average of individual Granger chi-square statistics) is given which is used
to derive the other two.

The Zbar statistic is not suitable for unbalanced panels. For the Wbar
statistic, no p-value is available.

The implementation uses \code{\link[lmtest:grangertest]{lmtest::grangertest()}} from
package \CRANpkg{lmtest} to perform the individual Granger tests.
}
\examples{

## not meaningful, just to demonstrate usage
## H0: 'value' Granger causes 'inv' for all invididuals

data("Grunfeld", package = "plm")
pgrangertest(inv ~ value, data = Grunfeld)
pgrangertest(inv ~ value, data = Grunfeld, order = 2L)
pgrangertest(inv ~ value, data = Grunfeld, order = 2L, test = "Zbar")

# varying lag order (last individual lag order 3, others lag order 2)
pgrangertest(inv ~ value, data = Grunfeld, order = c(rep(2L, 9), 3L))


}
\references{
\insertRef{DUMI:HURL:12}{plm}

\insertRef{GRAN:69}{plm}

\insertRef{LOPE:WEBE:17}{plm}
}
\seealso{
\code{\link[lmtest:grangertest]{lmtest::grangertest()}} for the original (non-panel)
Granger causality test in \CRANpkg{lmtest}.
}
\author{
Kevin Tappe
}
\keyword{htest}
