% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerQC.R
\name{overviewPerMarkerQC}
\alias{overviewPerMarkerQC}
\title{Overview of per marker QC}
\usage{
overviewPerMarkerQC(results_perMarkerQC, interactive = FALSE)
}
\arguments{
\item{results_perMarkerQC}{[list] Output of \code{\link{perIndividualQC}}
i.e. named [list] with i) fail_list, a named [list] with 1.
SNP_missingness, containing SNP IDs failing the missingness threshold
lmissTh, 2. hwe, containing SNP IDs failing the HWE exact test threshold
hweTh and 3. maf, containing SNPs failing the MAF threshold mafTh/MAC
threshold macTh and ii) p_markerQC, a ggplot2-object 'containing' a
sub-paneled plot with the QC-plots of \code{\link{check_snp_missingness}},
\code{\link{check_hwe}} and \code{\link{check_maf}}}

\item{interactive}{[logical] Should plots be shown interactively? When
choosing this option, make sure you have X-forwarding/graphical interface
available for interactive plotting. Alternatively, set interactive=FALSE and
save the returned plot object (p_overview) via ggplot2::ggsave(p=p_overview,
other_arguments) or pdf(outfile) print(p_overview) dev.off().}
}
\value{
Named [list] with i) nr_fail_markers: total number of markers
[integer] failing perMarkerQC, ii) fail_QC containing a [data.frame] with
markers that failed QC steps: marker rsIDs in rows,
columns are all QC steps applied by perMarkerQC (max=3), with entries=0 if
passing the QC and entries=1 if failing that particular QC.
}
\description{
Overview of per marker QC
}
\examples{
package.dir <- find.package('plinkQC')
indir <- file.path(package.dir, 'extdata')
qcdir <- tempdir()
name <- "data"
path2plink <- '/path/to/plink'
# the following code is not run on package build, as the path2plink on the
# user system is not known.
# All quality control checks
\dontrun{
fail_markers <- perMarkerQC(qcdir=qcdir, indir=indir, name=name,
interactive=FALSE, verbose=TRUE, path2plink=path2plink)
overview <- overviewPerMarkerQC(fail_markers)
}
}
