% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_prepare}
\alias{mosaic_prepare}
\title{Prepare a mosaic}
\usage{
mosaic_prepare(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  crop_mosaic = TRUE,
  align = TRUE,
  crop_aligned = TRUE,
  rescale = TRUE,
  coef = 0,
  viewer = "mapview",
  max_pixels = 5e+05,
  show = "rgb",
  index = "R"
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and  near-infrared bands
of the image, respectively. By default, the function assumes a BGR as input
(b = 1, g = 2, r = 3). If a multispectral image is provided up to seven
bands can be used to compute built-in indexes. There are no limitation of
band numbers if the index is computed using the band name.}

\item{crop_mosaic}{Logical, whether to crop the mosaic interactively before
aligning it (default: FALSE).}

\item{align}{Logical, whether to align the mosaic interactively (default:
TRUE).}

\item{crop_aligned}{Logical, whether to crop the aligned mosaic interactively
(default: TRUE).}

\item{rescale}{Rescale the final values? If \code{TRUE} the final values are
rescaled so that the maximum value is 1.}

\item{coef}{An addition coefficient applied to the resulting object. This is
useful to adjust the brightness of the final image. Defaults to 0.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{index}{The index to use for the index view. Defaults to "B".}
}
\value{
A prepared object of class \code{Image}.
}
\description{
Prepare an \code{SpatRaster} object to be analyzed in pliman. This includes
cropping the original mosaic, aligning it, and cropping the aligned object.
The resulting object is an object of class \code{Image} that can be further
analyzed.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
mosaic_prepare(mosaic)
}

}
