% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{utils_transform}
\alias{utils_transform}
\alias{image_autocrop}
\alias{image_crop}
\alias{image_dimension}
\alias{image_rotate}
\alias{image_horizontal}
\alias{image_vertical}
\alias{image_hreflect}
\alias{image_vreflect}
\alias{image_resize}
\alias{image_trim}
\alias{image_dilate}
\alias{image_erode}
\alias{image_opening}
\alias{image_closing}
\alias{image_skeleton}
\alias{image_thinning}
\alias{image_filter}
\alias{image_blur}
\alias{image_contrast}
\title{Spatial transformations}
\usage{
image_autocrop(
  img,
  index = "NB",
  edge = 5,
  filter = 3,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_crop(
  img,
  width = NULL,
  height = NULL,
  viewer = get_pliman_viewer(),
  show = "rgb",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_dimension(img, parallel = FALSE, workers = NULL, verbose = TRUE)

image_rotate(
  img,
  angle,
  bg_col = "white",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = TRUE
)

image_horizontal(
  img,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_vertical(
  img,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_hreflect(
  img,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_vreflect(
  img,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_resize(
  img,
  rel_size = 100,
  width,
  height,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_trim(
  img,
  edge = NULL,
  top = NULL,
  bottom = NULL,
  left = NULL,
  right = NULL,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_dilate(
  img,
  kern = NULL,
  size = NULL,
  shape = "disc",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_erode(
  img,
  kern = NULL,
  size = NULL,
  shape = "disc",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_opening(
  img,
  kern = NULL,
  size = NULL,
  shape = "disc",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_closing(
  img,
  kern = NULL,
  size = NULL,
  shape = "disc",
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_skeleton(
  img,
  kern = NULL,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE,
  ...
)

image_thinning(
  img,
  niter = 3,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE,
  ...
)

image_filter(
  img,
  size = 2,
  cache = 512,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_blur(
  img,
  sigma = 3,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)

image_contrast(
  img,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  plot = FALSE
)
}
\arguments{
\item{img}{An image or a list of images of class \code{Image}.}

\item{index}{The index to segment the image. See \code{\link[=image_index]{image_index()}} for more
details. Defaults to \code{"NB"} (normalized blue).}

\item{edge}{\itemize{
\item for \code{\link[=image_autocrop]{image_autocrop()}} the number of pixels in the edge of the cropped
image. If \code{edge = 0} the image will be cropped to create a bounding rectangle
(x and y coordinates) around the image objects.
\item for \code{\link[=image_trim]{image_trim()}}, the number of pixels removed from the edges. By
default, 20 pixels are removed from all the edges.
}}

\item{filter}{Performs median filtering in the binary image. This is useful
to remove noise (like dust) and improve the image autocropping method. See
more at \code{\link[=image_filter]{image_filter()}}. Set to \code{FALSE} to remove the median filtering.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 70\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{plot}{If \code{TRUE} plots the modified image. Defaults to \code{FALSE}.}

\item{width, height}{\itemize{
\item For \code{image_resize()} the Width and height of the resized image. These arguments
can be missing. In this case, the image is resized according to the
relative size informed in \code{rel_size}.
\item For \code{image_crop()} a numeric vector indicating the pixel range (x and y,
respectively) that will be maintained in the cropped image, e.g., width =
100:200
}}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{show}{How to plot in mapview viewer, either \code{"rgb"} or \code{"index"}.}

\item{angle}{The rotation angle in degrees.}

\item{bg_col}{Color used to fill the background pixels, defaults to \code{"white"}.}

\item{rel_size}{The relative size of the resized image. Defaults to 100. For
example, setting \code{rel_size = 50} to an image of width \verb{1280 x 720}, the new
image will have a size of \verb{640 x 360}.}

\item{top, bottom, left, right}{The number of pixels removed from \code{top},
\code{bottom}, \code{left}, and \code{right} when using \code{\link[=image_trim]{image_trim()}}.}

\item{kern}{An \code{Image} object or an array, containing the structuring
element. Defaults to a brushe generated with \code{\link[EBImage:morphology]{EBImage::makeBrush()}}.}

\item{size}{\itemize{
\item For \code{image_filter()} is the median filter radius (integer). Defaults to \code{3}.
\item For \code{image_dilate()} and \code{image_erode()} is an odd number containing the
size of the brush in pixels. Even numbers are rounded to the next odd one.
The default depends on the image resolution and is computed as the image
resolution (megapixels) times 20.
}}

\item{shape}{A character vector indicating the shape of the brush. Can be
\code{box}, \code{disc}, \code{diamond}, \code{Gaussian} or \code{line}. Default is \code{disc}.}

\item{...}{Additional arguments passed on to \code{\link[=image_binary]{image_binary()}}.}

\item{niter}{The number of iterations to perform in the thinning procedure.
Defaults to 3. Set to \code{NULL} to iterate until the binary image is no longer
changing.}

\item{cache}{The the L2 cache size of the system CPU in kB (integer).
Defaults to \code{512}.}

\item{sigma}{A numeric denoting the standard deviation of the Gaussian filter
used for blurring. Defaults to \code{3}.}
}
\value{
\itemize{
\item \code{image_skeleton()} returns a binary \code{Image} object.
\item All other functions returns a  modified version of \code{image} depending on the
\verb{image_*()} function used.
\item If \code{image} is a list, a list of the same length will be returned.
}
}
\description{
Performs image rotation and reflection
\itemize{
\item \verb{image autocrop()} Crops automatically  an image to the area of objects.
\item \code{image_crop()} Crops an image to the desired area.
\item \code{image_trim()} Remove pixels from the edges of an image (20 by default).
\item \code{image_dimension()} Gives the dimension (width and height) of an image.
\item \code{image_rotate()} Rotates the image clockwise by the given angle.
\item \code{image_horizontal()} Converts (if needed) an image to a horizontal image.
\item \code{image_vertical()} Converts (if needed) an image to a vertical image.
\item \code{image_hreflect()} Performs horizontal reflection of the \code{image}.
\item \code{image_vreflect()} Performs vertical reflection of the \code{image}.
\item \code{image_resize()} Resize the \code{image}. See more at \code{\link[EBImage:spatial]{EBImage::resize()}}.
\item \code{image_contrast()} Improve contrast locally by performing adaptive
histogram equalization. See more at \code{\link[EBImage:clahe]{EBImage::clahe()}}.
\item \code{image_dilate()} Performs image dilatation. See more at \code{\link[EBImage:morphology]{EBImage::dilate()}}.
\item \code{image_erode()} Performs image erosion. See more at \code{\link[EBImage:morphology]{EBImage::erode()}}.
\item \code{image_opening()} Performs an erosion followed by a dilation. See more at
\code{\link[EBImage:morphology]{EBImage::opening()}}.
\item \code{image_closing()} Performs a dilation followed by an erosion. See more at
\code{\link[EBImage:morphology]{EBImage::closing()}}.
\item \code{image_filter()} Performs median filtering in constant time. See more at
\code{\link[EBImage:medianFilter]{EBImage::medianFilter()}}.
\item \code{image_blur()} Performs blurring filter of images. See more at
\code{\link[EBImage:gblur]{EBImage::gblur()}}.
\item \code{image_skeleton()} Performs image skeletonization.
}
}
\examples{
library(pliman)
img <- image_pliman("sev_leaf.jpg")
plot(img)
img <- image_resize(img, 50)
img1 <- image_rotate(img, 45)
img2 <- image_hreflect(img)
img3 <- image_vreflect(img)
img4 <- image_vertical(img)
image_combine(img1, img2, img3, img4)
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
