% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\name{object_edge}
\alias{object_edge}
\title{Object edges}
\usage{
object_edge(img, sigma = 1, threshold = "Otsu", thinning = FALSE, plot = TRUE)
}
\arguments{
\item{img}{An image or a list of images of class \code{Image}.}

\item{sigma}{Gaussian kernel standard deviation used in the gaussian blur.}

\item{threshold}{The theshold method to be used.  If \code{threshold = "Otsu"}
(default), a threshold value based on Otsu's method is used to reduce the
grayscale image to a binary image. If any non-numeric value different than
\code{"Otsu"} is used, an iterative section will allow you to choose the
threshold based on a raster plot showing pixel intensity of the index.
Alternatively, provide a numeric value to be used as the threshold value.}

\item{thinning}{Logical value indicating whether a thinning procedure should
be applied to the detected edges. See \code{\link[=image_skeleton]{image_skeleton()}}}

\item{plot}{Logical value indicating whether a plot should be created}
}
\value{
A binary version of \code{image}.
}
\description{
Applies the Sobel-Feldman Operator to detect edges. The operator is based on
convolving the image with a small, separable, and integer-valued filter in
the horizontal and vertical directions.
}
\examples{
library(pliman)
img <- image_pliman("sev_leaf_nb.jpg", plot = TRUE)
object_edge(img)

}
\references{
Sobel, I., and G. Feldman. 1973. A 3×3 isotropic gradient
operator for image processing. Pattern Classification and Scene Analysis:
271–272.
}
